Triggers = {}

RocketClass = "Rocket Man"
MeleeClass = "The Boxer"
TimeClass = "Timekeeper"
MindControlClass = "Deceiver"
ForceClass = "Telekinetic"
FusionClass = "Fusion Master"
RifleClass = "Rifleman"
PyroClass = "Pyrotechnic"

FrozenOrbType = "Ice Orb"
YellowCrystalType = "Yellow Crystal"
DispersalDreamType = "Chain Burst"
LightningType = "Lightning"
HealthType = "Energy Can"
AmmoSelectorType = "Ammo Selector"
LaserType = "Laser"
ReflectionType = "Reflect"
FuryType = "Fury"
BlackHoleType = "Black Hole"
BeackpeackType = "Canvas Bag"

-- Class skills
FreezeTimeType = "Freeze Time" -- TimeClass
MindControlType = "Mind Control" -- MindControlClass
ShoveType = "Shove" -- ForceClass
HomingMissilesType = "Homing Missiles" -- RocketClass
RushType = "Rush" -- MeleeClass
ChargedBoltsType = "Charged Bolts" -- FusionCLass
GrenadePullType = "AR/SMG Skill" -- RifleClass
HitscanFlameType = "Throw Flame" -- PyroClass

White = {1, 1, 1}
Yellow = {1, 1, 0}
LighterGray = {.6, .6, .6}
Red = {1, 0, 0}
Black = {0, 0, 0}
Gray = {.2, .2, .2}
Green = {0, 1, 0}
DarkGray = {.2, .2, .2}
LightGray = {.4, .4, .4}
DimWhite = {1, 1, 1, .3}
DimGreen = {0, 1, 0, .3}
LightGold = {.9, .86, .56}
DimLightGold = {.9, .86, .56, .3}
DarkRed = {.75, 0, 0}
TimerRed = {1, 0, 0, .35}
BossYellow = {1, 1, 0, .35}

MotionSensorRange = 8

HardModeIndex = 10
ExtremeModeIndex = 11

TalkingBackgroundVariation = 1
TalkingBackgroundChanged = false

function draw_boss_health_bar(life, previous_life)
    local full_width = Screen.width - (Screen.width / 6) - (Screen.width / 6)
    local life_ratio = life / 2000
    local previous_life_ratio = previous_life / 2000
    if Game.difficulty == "easy" then
        life_ratio = life / 2500
        previous_life_ratio = previous_life / 2500
    elseif Game.difficulty == "normal" then
        life_ratio = life / 3000
        previous_life_ratio = previous_life / 3000
    elseif Game.difficulty == "major damage" then
        life_ratio = life / 3500
        previous_life_ratio = previous_life / 3500
    elseif Game.difficulty == "total carnage" then
        life_ratio = life / 4000
        previous_life_ratio = previous_life / 4000
    end
    if life_ratio > 0 then
        Screen.fill_rect(Screen.width / 6, Screen.height / 20, full_width * life_ratio, Screen.height / 20, TimerRed)
        Screen.fill_rect(
            (Screen.width / 6) + (full_width * life_ratio) + 1,
            Screen.height / 20,
            (full_width * previous_life_ratio) - (full_width * life_ratio),
            Screen.height / 20,
            BossYellow
        )
    end
    Screen.frame_rect(Screen.width / 6, Screen.height / 20, full_width, Screen.height / 20, TimerRed, 5)
end

function Triggers.draw()
    local p = Player

    local endscreen_state = get_stashed("endscreen_state")
    local endscreen_can_advance = get_stashed("endscreen_can_advance")
    local endscreen_good_ending = get_stashed("endscreen_good_ending")
    local class = get_stashed("class")
    local level = get_stashed_num("level")
    local projectile_levels = get_stashed_table("projectile_levels")
    local stats = get_stashed_table("stats")
    local difficulty_mode = get_stashed("difficulty_mode")
    local difficulty_average = get_stashed_num("difficulty_average")
    local num_conversations = get_stashed("num_conversations")
    local num_unique_responses = get_stashed("num_unique_responses")
    local num_max_secrets = get_stashed("num_max_secrets")
    local num_secrets_found = get_stashed("num_secrets_found")
    local ended_time = get_stashed("ended_time")
    local num_class_ability_activations = get_stashed("num_class_ability_activations")
    local endgame = get_stashed("endgame")
    local endgame_time_limit = get_stashed("endgame_time_limit")
    local good_ending = get_stashed("good_ending")
    local boss = get_stashed("boss")
    local boss_hit_history = get_stashed_table("boss_hit_history")

    if Level.index == HardModeIndex or Level.index == ExtremeModeIndex then
        if endscreen_state then
            local background_image
            if endscreen_good_ending == "true" and endscreen_state == "message" then
                background_image = imgs["endscreen_success_message"]
            elseif endscreen_good_ending == "true" then
                background_image = imgs["endscreen_success_score"]
            elseif endscreen_state == "message" then
                background_image = imgs["endscreen_failure_message"]
            else
                background_image = imgs["endscreen_failure_score"]
            end
            background_image:draw(0, 0)

            if endscreen_state == "message" then
                if endscreen_can_advance == "true" then
                    local msg = "<primary trigger to proceed to score>"
                    local w, h = fonts.small:measure_text(msg)
                    fonts.small:draw_text(msg, (Screen.width / 2) - (w / 2), Screen.height - h - adj(10), DarkRed)
                end
            else
                if endscreen_can_advance == "true" then
                    local msg = "<primary trigger to proceed to menu>"
                    local w, h = fonts.small:measure_text(msg)
                    fonts.small:draw_text(msg, (Screen.width / 2) - (w / 2), Screen.height - h - adj(10), DarkRed)
                end

                local score_rect = {
                    x = math.floor((Screen.width - (Screen.width * .8)) / 2),
                    y = math.floor((Screen.height - (Screen.height * .8)) / 2),
                    width = math.floor(Screen.width * .8),
                    height = math.floor(Screen.height * .8)
                }
                -- Screen.fill_rect(score_rect.x, score_rect.y, score_rect.width, score_rect.height, Black)
                -- Screen.frame_rect(
                --     score_rect.x,
                --     score_rect.y,
                --     score_rect.width,
                --     score_rect.height,
                --     Gray,
                --     Screen.width / 640
                -- )

                local msg = string.format("Level %d %s", level, class)
                local w, h = fonts.medium:measure_text(msg)
                local y = score_rect.y + adj(10)
                fonts.medium:draw_text(msg, math.floor((Screen.width / 2) - (w / 2)), y, Green)
                y = y + h + adj(20)

                local header_y = y

                ---- Body count section

                -- Labels
                local x = score_rect.x + adj(20)
                y = header_y
                msg = "Body Count"
                w, h = fonts.medium:measure_text(msg)
                fonts.medium:draw_text(msg, x, y, Yellow)
                y = y + h + adj(10)

                msg = "(monster deaths)"
                w, h = fonts.small:measure_text(msg)
                fonts.small:draw_text(msg, x, y, Yellow)
                y = y + h + adj(10)

                local section_y = y

                local monster_labels = {
                    "Fighters:",
                    "Elite Fighters:",
                    "Drones:",
                    "Elite Drones:",
                    "Simulacrums:",
                    "Compilers:",
                    "Elite Compilers:",
                    "Hunters:",
                    "MOAHs:",
                    "Cyborgs:",
                    "MOACs:",
                    "Troopers:",
                    "Elite Troopers:",
                    "Enforcers:",
                    "Elite Enforcers:",
                    "Defenders:",
                    "IADDs:",
                    "Flame IADDs:",
                    "Juggernauts:"
                }

                for i = 1, #monster_labels do
                    msg = monster_labels[i]
                    w, h = fonts.small:measure_text(msg)
                    fonts.small:draw_text(msg, x, y, White)
                    y = y + h + adj(10)
                end

                -- Values
                x = score_rect.x + adj(230)
                y = section_y

                local body_counts = {
                    stats.body_count.fighters,
                    stats.body_count.elite_fighters,
                    stats.body_count.drones,
                    stats.body_count.elite_drones,
                    stats.body_count.assbobs,
                    stats.body_count.compilers,
                    stats.body_count.elite_compilers,
                    stats.body_count.hunters,
                    stats.body_count.moahs,
                    stats.body_count.cyborgs,
                    stats.body_count.moacs,
                    stats.body_count.troopers,
                    stats.body_count.elite_troopers,
                    stats.body_count.enforcers,
                    stats.body_count.elite_enforcers,
                    stats.body_count.defenders,
                    stats.body_count.iadds,
                    stats.body_count.flame_iadds,
                    stats.body_count.juggernauts
                }

                local body_count_total = 0
                for i = 1, #body_counts do
                    msg = body_counts[i]
                    body_count_total = body_count_total + msg
                    w, h = fonts.small:measure_text(msg)
                    fonts.small:draw_text(msg, x - w, y, LightGold)
                    y = y + h + adj(10)
                end

                ---- Accuracy section

                -- Labels
                x = score_rect.x + adj(280)
                y = header_y
                msg = "Accuracy"
                w, h = fonts.medium:measure_text(msg)
                fonts.medium:draw_text(msg, x, y, Yellow)
                y = y + h + adj(10)

                msg = "(level | shots | hits | %)"
                w, h = fonts.small:measure_text(msg)
                fonts.small:draw_text(msg, x, y, Yellow)
                y = y + h + adj(10)

                local projectile_labels = {
                    "Fists:",
                    "Pistol bullets:",
                    "Minor fusion bolts:",
                    "Major fusion bolts:",
                    "Shotgun bullets:",
                    "Rifle bullets:",
                    "Grenades:",
                    "SMG bullets:",
                    "Flamethrower:",
                    "Missiles:",
                    "Alien weapon:"
                }

                for i = 1, #projectile_labels do
                    msg = projectile_labels[i]
                    w, h = fonts.small:measure_text(msg)
                    fonts.small:draw_text(msg, x, y, White)
                    y = y + h + adj(10)
                end

                -- Values
                local percent
                local proj_type
                x = score_rect.x + adj(700)
                y = section_y

                local projectiles = {
                    "fist",
                    "pistol bullet",
                    "fusion bolt minor",
                    "fusion bolt major",
                    "shotgun bullet",
                    "rifle bullet",
                    "grenade",
                    "smg bullet",
                    "flamethrower burst",
                    "missile",
                    "alien weapon"
                }

                for i = 1, #projectiles do
                    proj_type = projectiles[i]
                    percent =
                        stats.shots[proj_type] > 0 and
                        math.floor(stats.hits[proj_type] / stats.shots[proj_type] * 100 + .5) or
                        "NA"
                    msg =
                        string.format(
                        "%d | %d | %d | %s%%",
                        projectile_levels[proj_type],
                        stats.shots[proj_type],
                        stats.hits[proj_type],
                        percent
                    )
                    w, h = fonts.small:measure_text(msg)
                    fonts.small:draw_text(msg, x - w, y, LightGold)
                    y = y + h + adj(10)
                end

                ---- Spells section
                x = score_rect.x + adj(750)
                y = header_y
                msg = "Spells"
                w, h = fonts.medium:measure_text(msg)
                fonts.medium:draw_text(msg, x, y, Yellow)
                y = y + h + adj(10)

                msg = "(picked up | used | kills)"
                w, h = fonts.small:measure_text(msg)
                fonts.small:draw_text(msg, x, y, Yellow)
                y = y + h + adj(10)

                local spell_labels = {
                    "Lasers:",
                    "Lightnings:",
                    "Chain bursts:",
                    "Ice orbs:",
                    "Furys:",
                    "Reflects:",
                    "Black holes:",
                    "Ammo Selectors:",
                    "Health Cans"
                }

                for i = 1, #spell_labels do
                    msg = spell_labels[i]
                    w, h = fonts.small:measure_text(msg)
                    fonts.small:draw_text(msg, x, y, White)
                    y = y + h + adj(10)
                end

                -- Values
                x = score_rect.x + adj(1100)
                y = section_y

                stats.spells.lasers.used = math.floor(stats.spells.lasers.used / 30)

                local spells = {
                    stats.spells.lasers,
                    stats.spells.lightnings,
                    stats.spells.chain_bursts,
                    stats.spells.ice_orbs,
                    stats.spells.furys,
                    stats.spells.reflects,
                    stats.spells.black_holes,
                    stats.spells.ammo_selectors,
                    stats.spells.cans
                }

                local spell_kills = 0
                for i = 1, #spells do
                    local spell = spells[i]
                    spell_kills = spell_kills + spell.kills
                    msg = string.format("%d | %d | %d", spell.picked_up, spell.used, spell.kills)
                    w, h = fonts.small:measure_text(msg)
                    fonts.small:draw_text(msg, x - w, y, LightGold)
                    y = y + h + adj(10)
                end

                ---- Score section
                x = score_rect.x + adj(750)
                y = y + adj(20)
                msg = "Score"
                w, h = fonts.medium:measure_text(msg)
                fonts.medium:draw_text(msg, x, y, Yellow)
                y = y + h + adj(10)

                section_y = y

                local score_labels = {
                    "Mission:",
                    "Body count:",
                    "Difficulty:",
                    "Spell kills:",
                    "Class Activations:",
                    "Cans used:"
                }

                for i = 1, #score_labels do
                    msg = score_labels[i]
                    w, h = fonts.small:measure_text(msg)
                    fonts.small:draw_text(msg, x, y, White)
                    y = y + h + adj(10)
                end

                y = y + adj(20)
                msg = "Total Score:"
                w, h = fonts.medium:measure_text(msg)
                fonts.medium:draw_text(msg, x, y, White)
                y = y + h + adj(10)

                -- Values
                x = score_rect.x + adj(1100)
                y = section_y

                local scores = {
                    {get_mission_bonus(endscreen_good_ending)},
                    {get_body_count_bonus(body_count_total)},
                    {get_difficulty_bonus(difficulty_average, difficulty_mode)},
                    {get_spell_kills_bonus(spell_kills)},
                    {get_class_activation_bonus(tonumber(num_class_ability_activations))},
                    {get_cans_penalty(difficulty_mode, stats.spells.cans.used)}
                }

                local total_socre = 0
                for i = 1, #scores do
                    local score = scores[i][1]
                    local msg = scores[i][2]
                    total_socre = total_socre + score
                    w, h = fonts.small:measure_text(msg)
                    fonts.small:draw_text(msg, x - w, y, LightGold)
                    y = y + h + adj(10)
                end

                y = y + adj(20)
                msg = total_socre
                w, h = fonts.medium:measure_text(msg)
                fonts.medium:draw_text(msg, x - w, y, LightGold)
                y = y + h + adj(10)

                ---- Misc section
                header_y = score_rect.y + adj(440)

                x = score_rect.x + adj(280)
                y = header_y
                msg = "Misc"
                w, h = fonts.medium:measure_text(msg)
                fonts.medium:draw_text(msg, x, y, Yellow)
                y = y + h + adj(10)

                section_y = y

                local misc_labels = {
                    "Mission:",
                    "Time played:",
                    "Secrets found:",
                    "Bodies talked to:",
                    "Unique body responses:",
                    "Class ability activations:"
                }

                for i = 1, #misc_labels do
                    msg = misc_labels[i]
                    w, h = fonts.small:measure_text(msg)
                    fonts.small:draw_text(msg, x, y, White)
                    y = y + h + adj(10)
                end

                -- Values
                x = score_rect.x + adj(700)
                y = section_y

                local misc = {
                    endscreen_good_ending == "true" and "Success" or "Failure",
                    get_time_played(ended_time),
                    num_secrets_found .. " / " .. num_max_secrets,
                    num_conversations,
                    num_unique_responses,
                    num_class_ability_activations
                }

                for i = 1, #misc do
                    local msg = misc[i]
                    w, h = fonts.small:measure_text(msg)
                    fonts.small:draw_text(msg, x - w, y, LightGold)
                    y = y + h + adj(10)
                end
            end
        else
            Screen.fill_rect(0, 0, Screen.width, Screen.height, Black)
        end
        return
    end

    MotionSensorScale = imgs["motion sensor"].height * .42

    local ephemera_quality = get_stashed("ephemera_quality")
    if ephemera_quality == "off" then
        Screen.fill_rect(0, 0, Screen.width, Screen.height, {0, 0, 0})
        local msg = "This scenario requires 'Scripted Effects Quality' to be turned on."
        local msg2 =
            "Go to Preferences -> Graphics -> Rendering Options, and set Scripted Effects Quality to Low or higher."
        local width1, _ = fonts.small:measure_text(msg)
        local width2, _ = fonts.small:measure_text(msg2)
        fonts.small:draw_text(msg, (Screen.width / 2) - (width1 / 2), Screen.height / 4, White)
        fonts.small:draw_text(msg2, Screen.width / 2 - width2 / 2, Screen.height / 2, White)
        return
    end

    if Game.version < "20240712" then
        Screen.fill_rect(0, 0, Screen.width, Screen.height, {0, 0, 0})
        local msg = "This scenario requires Aleph One 1.9 or newer. Please update your version of Aleph One."
        local w, _ = fonts.small:measure_text(msg)
        fonts.small:draw_text(msg, (Screen.width / 2) - (w / 2), Screen.height / 4, White)
        return
    end

    local inventory = get_stashed_table("inventory")
    local inventory_data = read_inventory(inventory)

    local equipped_spell_tick = get_stashed_num("equipped_spell_tick")
    local equipped_elapsed_ticks = Game.ticks - equipped_spell_tick
    if equipped_elapsed_ticks < 30 and inventory_data.active_item then
        local image = imgs[inventory_data.active_item.type .. "Large"]
        image.tint_color = {1, 1, 1, .1 * (15 - (equipped_elapsed_ticks - 15))}
        local x = Screen.width / 2
        local y = Screen.height / 2 - Screen.height / 5
        image:draw(x - (image.width / 2), y - (image.height / 2))
    end

    local survival_score = get_stashed("survival_score")
    if survival_score then
        fonts.medium:draw_text("Score: " .. survival_score, Screen.width - Screen.width / 5, 2, {1, 1, 0})
    end

    local survival_time = get_stashed_num("survival_time")
    local survival_ended = get_stashed("survival_ended")
    local time_color = {0, 1, 0}
    if survival_ended == "true" then
        time_color = {1, 0, 0}
    end
    if survival_time then
        fonts.medium:draw_text(game_time_str(survival_time), Screen.width - Screen.width / 10, 2, time_color)
    end

    -- talking to body
    local talk_response = get_stashed("talk_response")
    if talk_response then
        if Game.ticks % 4 == 0 then
            if not TalkingBackgroundChanged then
                TalkingBackgroundChanged = true
                TalkingBackgroundVariation = TalkingBackgroundVariation + 1
                if TalkingBackgroundVariation > 4 then
                    TalkingBackgroundVariation = 1
                end
            end
        else
            TalkingBackgroundChanged = false
        end
        local image_name = "talking_background" .. TalkingBackgroundVariation
        local talkfont = Fonts.new {id = 22, size = adj(14), style = 1}
        local lines = message_to_lines(talk_response, 80)
        local tx = Screen.text_margins.left
        local _, h = talkfont:measure_text("")
        local ty = Screen.height - adj(90) - imgs[image_name].height + adj(85)
        imgs[image_name]:draw(Screen.text_margins.left - adj(35), Screen.height - adj(90) - imgs[image_name].height)
        for i = 1, #lines do
            talkfont:draw_text(lines[i], tx, ty, White)
            ty = ty + h
        end
    end

    -- help screen
    local mic_active = get_stashed("microphone_active")
    local class = get_stashed("class")
    local filter_enabled = get_stashed("overheadmap_filter_enabled")
    if Screen.map_active then
        if mic_active and mic_active == "true" then
            local rectwidth = math.ceil(Screen.width * .85)
            local rectheight = math.ceil((Screen.height - adj(90)) * .85)
            local rectx = math.ceil((Screen.width / 2) - (rectwidth / 2))
            local recty = math.ceil(((Screen.height - adj(90)) / 2) - (rectheight / 2))

            Screen.fill_rect(rectx, recty, rectwidth, rectheight, Black)
            Screen.frame_rect(rectx, recty, rectwidth, rectheight, Gray, Screen.width / 640)

            local colpadding = math.ceil(Screen.width / 60)

            local hotkey_bindings = get_stashed_table("hotkey_bindings")
            local _, header_h = fonts.small:measure_text("")
            local _, text_h = fonts.smaller:measure_text("")
            header_h = header_h + adj(5)
            text_h = text_h + adj(5)
            local y = recty + header_h
            fonts.small:draw_text("Class:", rectx + colpadding, y, InterfaceColors["computer yellow text"])

            if difficulty_mode == "HardMode" then
                local difficulty_msg = "Hard Mode (Healing restores 1/2 health)"
                local width, _ = fonts.small:measure_text(difficulty_msg)
                fonts.small:draw_text(
                    difficulty_msg,
                    rectx + rectwidth - colpadding - width,
                    y,
                    InterfaceColors["computer red text"]
                )
            elseif difficulty_mode == "ExtremeMode" then
                local difficulty_msg = "Extreme Mode (Healing restores 1/3 health)"
                local width, _ = fonts.small:measure_text(difficulty_msg)
                fonts.small:draw_text(
                    difficulty_msg,
                    rectx + rectwidth - colpadding - width,
                    y,
                    InterfaceColors["computer red text"]
                )
            end

            y = y + header_h
            local textpart1 = "Active Skill ("
            local part1w, _ = fonts.smaller:measure_text(textpart1)
            local textpart2 = hotkey_bindings[10]
            local part2w, _ = fonts.smaller:measure_text(textpart2)
            local textpart3 = "):"
            fonts.smaller:draw_text(textpart1, rectx + colpadding, y, White)
            fonts.smaller:draw_text(textpart2, rectx + colpadding + part1w, y, Green)
            fonts.smaller:draw_text(textpart3, rectx + colpadding + part1w + part2w, y, White)
            local active1, active2 = get_active_text(class)
            y = y + text_h
            fonts.smaller:draw_text(active1, rectx + colpadding + adj(10), y, LighterGray)
            y = y + text_h
            fonts.smaller:draw_text(active2, rectx + colpadding + adj(10), y, LighterGray)

            y = y + header_h
            fonts.smaller:draw_text("Passive Skill (always active):", rectx + colpadding, y, White)
            local passive1, passive2 = get_passive_text(class)
            y = y + text_h
            fonts.smaller:draw_text(passive1, rectx + colpadding + adj(10), y, LighterGray)
            y = y + text_h
            fonts.smaller:draw_text(passive2, rectx + colpadding + adj(10), y, LighterGray)

            y = y + header_h + adj(10)
            fonts.small:draw_text("Health:", rectx + colpadding, y, InterfaceColors["computer yellow text"])
            y = y + header_h

            textpart1 = "Use energy cans to restore health on demand ("
            part1w, _ = fonts.smaller:measure_text(textpart1)
            textpart2 = hotkey_bindings[12]
            part2w, _ = fonts.smaller:measure_text(textpart2)
            textpart3 = "). The number you are carrying can be viewed next to your health in the HUD."
            fonts.smaller:draw_text(textpart1, rectx + colpadding, y, White)
            fonts.smaller:draw_text(textpart2, rectx + colpadding + part1w, y, Green)
            fonts.smaller:draw_text(textpart3, rectx + colpadding + part1w + part2w, y, White)

            y = y + header_h + adj(10)
            fonts.small:draw_text("Spells:", rectx + colpadding, y, InterfaceColors["computer yellow text"])

            y = y + header_h
            fonts.smaller:draw_text(
                "To select spells, hold down the aux trigger and use prev/next weapon buttons.",
                rectx + colpadding,
                y,
                White
            )
            y = y + text_h

            textpart1 = "Press the "
            part1w, _ = fonts.smaller:measure_text(textpart1)
            textpart2 = hotkey_bindings[11]
            part2w, _ = fonts.smaller:measure_text(textpart2)
            textpart3 = " button to cast the currently selected spell."
            fonts.smaller:draw_text(textpart1, rectx + colpadding, y, White)
            fonts.smaller:draw_text(textpart2, rectx + colpadding + part1w, y, Green)
            fonts.smaller:draw_text(textpart3, rectx + colpadding + part1w + part2w, y, White)

            y = y + text_h + adj(20)
            local spellrectwidth = math.floor(((rectwidth - colpadding) - (colpadding * 3)) / 3)
            local rowpadding = math.floor(rectheight / 40)
            local spellrectheight = math.floor(((rectheight - (y - recty)) - (rowpadding * 3)) / 3)

            row1 = y
            row2 = row1 + rowpadding + spellrectheight
            row3 = row2 + rowpadding + spellrectheight

            col1 = rectx + colpadding
            col2 = col1 + colpadding + spellrectwidth
            col3 = col2 + colpadding + spellrectwidth

            local has_gotten = get_stashed_table("has_gotten")
            local spellfont = Fonts.new {id = 22, size = adj(14), style = 1}
            local cols = 52
            local ypadding = 8
            if Screen.hud_size_preference == "double" then
                cols = 50
                spellfont = Fonts.new {id = 22, size = adj(12), style = 1}
            elseif Screen.hud_size_preference == "largest" then
                spellfont = Fonts.new {id = 22, size = adj(9), style = 1}
                cols = 58
            end
            local _, spell_desc_h = spellfont:measure_text("")

            Screen.fill_rect(col1, row1, spellrectwidth, spellrectheight, Black)
            Screen.frame_rect(col1, row1, spellrectwidth, spellrectheight, Gray, Screen.width / 640)

            if has_gotten[LaserType] then
                imgs[LaserType]:draw(
                    get_spell_help_x(col1, spellrectwidth, false),
                    get_spell_help_y(row1, spellrectheight)
                )
                local lines = message_to_lines(get_description_laser(), cols)
                local tx = get_spell_help_text_x(col1)
                local ty = row1 + ypadding
                for i = 1, #lines do
                    spellfont:draw_text(lines[i], tx, ty, White)
                    ty = ty + spell_desc_h
                end
            else
                imgs["unknown"]:draw(
                    get_spell_help_x(col1, spellrectwidth, true),
                    get_spell_help_y(row1, spellrectheight)
                )
            end

            Screen.fill_rect(col1, row2, spellrectwidth, spellrectheight, Black)
            Screen.frame_rect(col1, row2, spellrectwidth, spellrectheight, Gray, Screen.width / 640)

            if has_gotten[LightningType] then
                imgs[LightningType]:draw(
                    get_spell_help_x(col1, spellrectwidth, false),
                    get_spell_help_y(row2, spellrectheight)
                )
                local lines = message_to_lines(get_description_lightning(), cols)
                local tx = get_spell_help_text_x(col1)
                local ty = row2 + ypadding
                for i = 1, #lines do
                    spellfont:draw_text(lines[i], tx, ty, White)
                    ty = ty + spell_desc_h
                end
            else
                imgs["unknown"]:draw(
                    get_spell_help_x(col1, spellrectwidth, true),
                    get_spell_help_y(row2, spellrectheight)
                )
            end

            Screen.fill_rect(col1, row3, spellrectwidth, spellrectheight, Black)
            Screen.frame_rect(col1, row3, spellrectwidth, spellrectheight, Gray, Screen.width / 640)

            if has_gotten[DispersalDreamType] then
                imgs[DispersalDreamType]:draw(
                    get_spell_help_x(col1, spellrectwidth, false),
                    get_spell_help_y(row3, spellrectheight)
                )
                local lines = message_to_lines(get_description_dispersal_dream(), cols)
                local tx = get_spell_help_text_x(col1)
                local ty = row3 + ypadding
                for i = 1, #lines do
                    spellfont:draw_text(lines[i], tx, ty, White)
                    ty = ty + spell_desc_h
                end
            else
                imgs["unknown"]:draw(
                    get_spell_help_x(col1, spellrectwidth, true),
                    get_spell_help_y(row3, spellrectheight)
                )
            end

            Screen.fill_rect(col2, row1, spellrectwidth, spellrectheight, Black)
            Screen.frame_rect(col2, row1, spellrectwidth, spellrectheight, Gray, Screen.width / 640)

            if has_gotten[FrozenOrbType] then
                imgs[FrozenOrbType]:draw(
                    get_spell_help_x(col2, spellrectwidth, false),
                    get_spell_help_y(row1, spellrectheight)
                )
                local lines = message_to_lines(get_description_frozen_orb(), cols)
                local tx = get_spell_help_text_x(col2)
                local ty = row1 + ypadding
                for i = 1, #lines do
                    spellfont:draw_text(lines[i], tx, ty, White)
                    ty = ty + spell_desc_h
                end
            else
                imgs["unknown"]:draw(
                    get_spell_help_x(col2, spellrectwidth, true),
                    get_spell_help_y(row1, spellrectheight)
                )
            end

            Screen.fill_rect(col2, row2, spellrectwidth, spellrectheight, Black)
            Screen.frame_rect(col2, row2, spellrectwidth, spellrectheight, Gray, Screen.width / 640)

            if has_gotten[FuryType] then
                imgs[FuryType]:draw(
                    get_spell_help_x(col2, spellrectwidth, false),
                    get_spell_help_y(row2, spellrectheight)
                )
                local lines = message_to_lines(get_description_fury(), cols)
                local tx = get_spell_help_text_x(col2)
                local ty = row2 + ypadding
                for i = 1, #lines do
                    spellfont:draw_text(lines[i], tx, ty, White)
                    ty = ty + spell_desc_h
                end
            else
                imgs["unknown"]:draw(
                    get_spell_help_x(col2, spellrectwidth, true),
                    get_spell_help_y(row2, spellrectheight)
                )
            end

            Screen.fill_rect(col2, row3, spellrectwidth, spellrectheight, Black)
            Screen.frame_rect(col2, row3, spellrectwidth, spellrectheight, Gray, Screen.width / 640)

            if has_gotten[ReflectionType] then
                imgs[ReflectionType]:draw(
                    get_spell_help_x(col2, spellrectwidth, false),
                    get_spell_help_y(row3, spellrectheight)
                )
                local lines = message_to_lines(get_description_reflection(), cols)
                local tx = get_spell_help_text_x(col2)
                local ty = row3 + ypadding
                for i = 1, #lines do
                    spellfont:draw_text(lines[i], tx, ty, White)
                    ty = ty + spell_desc_h
                end
            else
                imgs["unknown"]:draw(
                    get_spell_help_x(col2, spellrectwidth, true),
                    get_spell_help_y(row3, spellrectheight)
                )
            end

            Screen.fill_rect(col3, row1, spellrectwidth, spellrectheight, Black)
            Screen.frame_rect(col3, row1, spellrectwidth, spellrectheight, Gray, Screen.width / 640)

            if has_gotten[BlackHoleType] then
                imgs[BlackHoleType]:draw(
                    get_spell_help_x(col3, spellrectwidth, false),
                    get_spell_help_y(row1, spellrectheight)
                )
                local lines = message_to_lines(get_description_black_hole(), cols)
                local tx = get_spell_help_text_x(col3)
                local ty = row1 + ypadding
                for i = 1, #lines do
                    spellfont:draw_text(lines[i], tx, ty, White)
                    ty = ty + spell_desc_h
                end
            else
                imgs["unknown"]:draw(
                    get_spell_help_x(col3, spellrectwidth, true),
                    get_spell_help_y(row1, spellrectheight)
                )
            end

            Screen.fill_rect(col3, row2, spellrectwidth, spellrectheight, Black)
            Screen.frame_rect(col3, row2, spellrectwidth, spellrectheight, Gray, Screen.width / 640)

            if has_gotten[AmmoSelectorType] then
                imgs[AmmoSelectorType]:draw(
                    get_spell_help_x(col3, spellrectwidth, false),
                    get_spell_help_y(row2, spellrectheight)
                )
                local lines = message_to_lines(get_description_ammo_selector(), cols)
                local tx = get_spell_help_text_x(col3)
                local ty = row2 + ypadding
                for i = 1, #lines do
                    spellfont:draw_text(lines[i], tx, ty, White)
                    ty = ty + spell_desc_h
                end
            else
                imgs["unknown"]:draw(
                    get_spell_help_x(col3, spellrectwidth, true),
                    get_spell_help_y(row2, spellrectheight)
                )
            end

            Screen.fill_rect(col3, row3, spellrectwidth, spellrectheight, Black)
            Screen.frame_rect(col3, row3, spellrectwidth, spellrectheight, Gray, Screen.width / 640)

            if has_gotten[YellowCrystalType] then
                imgs[YellowCrystalType]:draw(
                    get_spell_help_x(col3, spellrectwidth, false),
                    get_spell_help_y(row3, spellrectheight)
                )
                local lines = message_to_lines(get_description_yellow_crystal(), cols)
                local tx = get_spell_help_text_x(col3)
                local ty = row3 + ypadding
                for i = 1, #lines do
                    spellfont:draw_text(lines[i], tx, ty, White)
                    ty = ty + spell_desc_h
                end
            else
                imgs["unknown"]:draw(
                    get_spell_help_x(col3, spellrectwidth, true),
                    get_spell_help_y(row3, spellrectheight)
                )
            end

            local msg =
                string.format(
                "Press %s to toggle a filter for the map. Only available in some locations with overlapping areas.",
                hotkey_bindings[1]
            )
            local w, h = fonts.small:measure_text(msg)
            Screen.fill_rect(
                (Screen.width / 2) - (w / 2) - 10,
                Screen.height - adj(110) - h - 10,
                w + 20,
                h + 20,
                Black
            )
            Screen.frame_rect(
                (Screen.width / 2) - (w / 2) - 10,
                Screen.height - adj(110) - h - 10,
                w + 20,
                h + 20,
                Gray,
                Screen.width / 640
            )
            fonts.small:draw_text(msg, (Screen.width / 2) - (w / 2), Screen.height - adj(110) - h, Yellow)
        else
            imgs["legend"]:draw(Screen.width - imgs["legend"].width, Screen.height - adj(90) - imgs["legend"].height)

            local msg = "Hold aux trigger to view help"
            local w, h = fonts.small:measure_text(msg)
            fonts.small:draw_text(msg, (Screen.width / 2) - (w / 2), Screen.height - adj(90) - h, White)

            if filter_enabled == "true" then
                msg = "Map filter active"
                local w, h = fonts.small:measure_text(msg)
                fonts.small:draw_text(msg, Screen.width - w - 20, 10, Red)
            end
        end
    end

    local class_selection = get_stashed("class_selection")
    if class_selection then
        Screen.fill_rect(Screen.width / 3.2, Screen.height / 10, Screen.width, Screen.height, Black)
    end

    Screen.fill_rect(0, Screen.height - adj(90), Screen.width, adj(90), Black)
    imgs["background"]:draw(locations.background.x, locations.background.y)

    -- Endgame timer
    if endgame == "true" then
        local remaining_ticks = endgame_time_limit - Game.ticks
        if remaining_ticks > 0 then
            local remaining_time = game_time_str(remaining_ticks, true)
            local label = "Defense activation: "
            if good_ending ~= "true" then
                label = "Reactor explosion: "
            end
            local msg = label .. remaining_time
            local w, h = fonts.medium:measure_text(msg)

            Screen.fill_rect((Screen.width / 2) - (w / 2) - 40, 0, w + 80, h + 20, TimerRed)
            fonts.medium:draw_text(msg, math.floor((Screen.width / 2) - (w / 2)), 10, White)
        end
    end

    -- Boss healthbar
    if boss then
        local previous_health = boss
        for i = 1, 45 do
            previous_health = previous_health + boss_hit_history[i]
        end
        draw_boss_health_bar(boss, previous_health)

        local msg = "Prototype IADD"
        local w, h = fonts.medium:measure_text(msg)
        fonts.medium:draw_text(msg, math.floor((Screen.width / 2) - (w / 2)), Screen.height / 20 + (h / 2), White)
    end

    local max_hp = get_stashed_num("max_hp")
    local health_percent = p.life / 150.0
    local hp = math.ceil(health_percent * max_hp)
    local health_color, health_color_name = get_percent_color(health_percent)

    local filler_image = imgs["filler"]
    local class_cooldown_ended_tick = get_stashed_num("class_cooldown_ended_tick")
    if class_cooldown_ended_tick then
        local class_ability_ready_elapsed_ticks = Game.ticks - class_cooldown_ended_tick
        if class_ability_ready_elapsed_ticks < 37 then
            local filler_alpha = .027 * (37 - class_ability_ready_elapsed_ticks)
            filler_image = imgs["filler active"]
            filler_image.tint_color = {1, 1, 1, filler_alpha}
        end
    end

    local filler_width = filler_image.width
    local start_left_filler_x = (Screen.width / 2) - adj(570)
    local start_right_filler_x = (Screen.width / 2) + adj(570)
    local filler_num = math.ceil(start_left_filler_x / filler_width)
    for i = 1, filler_num do
        filler_image:draw(start_left_filler_x - (filler_width * i), Screen.height - adj(90))
        filler_image:draw(start_right_filler_x + (filler_width * (i - 1)), Screen.height - adj(90))
        if health_color_name == "red" then
            local image = imgs["filler red"]
            image:draw(start_left_filler_x - (filler_width * i), Screen.height - adj(90))
            image:draw(start_right_filler_x + (filler_width * (i - 1)), Screen.height - adj(90))
        end
    end

    local bar_width = math.ceil(locations.health_bar.width * health_percent)
    Screen.fill_rect(
        locations.health_bar.x,
        locations.health_bar.y,
        bar_width,
        locations.health_bar.height,
        health_color
    )
    draw_item("health outline " .. health_color_name, locations.health_outline.x, locations.health_outline.y, true)

    draw_inventory_text(hp .. "/" .. max_hp, locations.health.x, locations.health.y, health_color)

    local oxygen = get_oxygen_percent()
    draw_inventory_text(oxygen .. "%", locations.oxygen.x, locations.oxygen.y, InterfaceColors["computer cyan text"])

    local cycle_weapons = get_stashed("cycle_weapons")
    if cycle_weapons == "true" then
        draw_item("cycleweppies", locations.cycle_weapons.x, locations.cycle_weapons.y, true)
    else
        draw_item("cyclespells", locations.cycle_spells.x, locations.cycle_spells.y, true)
    end

    local projectile_progress = get_stashed_table("projectile_progress")
    local projectile_levelup_requirements = get_stashed_table("projectile_levelup_requirements")

    if p.items["knife"].count > 0 then
        draw_item("fist", locations.fist_label.x, locations.fist_label.y, false)
    end

    if p.items["pistol ammo"].count > 0 or p.items["pistol"].count > 0 then
        draw_inventory_text(p.items["pistol ammo"].count, locations.pistol_num.x, locations.pistol_num.y, DimGreen)
        draw_item("pistol", locations.pistol_label.x, locations.pistol_label.y, false)

        if p.items["pistol"].count == 0 then
            draw_item("crossedout", locations.pistol_label.x, locations.pistol_label.y, true)
        end

        level_color = DimWhite
        location_y = locations.pistol_level.y - adj(2)
        if projectile_levels["pistol bullet"] == 10 then
            level_color = DimLightGold
            location_y = locations.pistol_level.y
        end
        draw_inventory_text(projectile_levels["pistol bullet"], locations.pistol_level.x, location_y, level_color)
        if level_color == DimWhite then
            Screen.fill_rect(
                locations.pistol_level.x - adj(10),
                locations.pistol_level.y + adj(6),
                adj(20),
                adj(2),
                DarkGray
            )

            local ratio = projectile_progress["pistol bullet"] / projectile_levelup_requirements["pistol bullet"]
            local width = math.ceil(ratio * 20)
            Screen.fill_rect(
                locations.pistol_level.x - adj(10),
                locations.pistol_level.y + adj(6),
                adj(width),
                adj(2),
                DimWhite
            )
        end
    end

    if p.items["fusion pistol ammo"].count > 0 or p.items["fusion pistol"].count > 0 then
        draw_inventory_text(
            p.items["fusion pistol ammo"].count,
            locations.fusion_num.x,
            locations.fusion_num.y,
            DimGreen
        )
        draw_item("fusion", locations.fusion_label.x, locations.fusion_label.y, false)

        if p.items["fusion pistol"].count == 0 then
            draw_item("crossedout", locations.fusion_label.x, locations.fusion_label.y, true)
        end

        level_color = DimWhite
        location_y = locations.fusion_level.y - adj(2)
        if projectile_levels["fusion bolt minor"] == 10 then
            level_color = DimLightGold
            location_y = locations.fusion_level.y
        end

        draw_inventory_text(projectile_levels["fusion bolt minor"], locations.fusion_level.x, location_y, level_color)

        if level_color == DimWhite then
            Screen.fill_rect(
                locations.fusion_level.x - adj(10),
                locations.fusion_level.y + adj(6),
                adj(20),
                adj(2),
                DarkGray
            )
            local ratio =
                projectile_progress["fusion bolt minor"] / projectile_levelup_requirements["fusion bolt minor"]
            local width = math.ceil(ratio * 20)
            Screen.fill_rect(
                locations.fusion_level.x - adj(10),
                locations.fusion_level.y + adj(6),
                adj(width),
                adj(2),
                DimWhite
            )
        end
    end

    if p.items["shotgun ammo"].count > 0 or p.items["shotgun"].count > 0 then
        draw_inventory_text(p.items["shotgun ammo"].count, locations.shotgun_num.x, locations.shotgun_num.y, DimGreen)
        draw_item("shotgun", locations.shotgun_label.x, locations.shotgun_label.y, false)

        if p.items["shotgun"].count == 0 then
            draw_item("crossedout", locations.shotgun_label.x, locations.shotgun_label.y, true)
        end

        level_color = DimWhite
        location_y = locations.shotgun_level.y - adj(2)
        if projectile_levels["shotgun bullet"] == 10 then
            level_color = DimLightGold
            location_y = locations.shotgun_level.y
        end

        draw_inventory_text(projectile_levels["shotgun bullet"], locations.shotgun_level.x, location_y, level_color)

        if level_color == DimWhite then
            Screen.fill_rect(
                locations.shotgun_level.x - adj(10),
                locations.shotgun_level.y + adj(6),
                adj(20),
                adj(2),
                DarkGray
            )
            local ratio = projectile_progress["shotgun bullet"] / projectile_levelup_requirements["shotgun bullet"]
            local width = math.ceil(ratio * 20)
            Screen.fill_rect(
                locations.shotgun_level.x - adj(10),
                locations.shotgun_level.y + adj(6),
                adj(width),
                adj(2),
                DimWhite
            )
        end
    end

    if
        p.items["assault rifle ammo"].count > 0 or p.items["assault rifle grenades"].count > 0 or
            p.items["assault rifle"].count > 0
     then
        draw_inventory_text(
            p.items["assault rifle ammo"].count .. "/" .. p.items["assault rifle grenades"].count,
            locations.ar_num.x,
            locations.ar_num.y,
            DimGreen
        )
        draw_item("ar", locations.ar_label.x, locations.ar_label.y, false)

        if p.items["assault rifle"].count == 0 then
            draw_item("crossedout", locations.ar_label.x, locations.ar_label.y, true)
        end

        level_color = DimWhite
        location_y = locations.ar_level.y - adj(2)
        if projectile_levels["rifle bullet"] == 10 then
            level_color = DimLightGold
            location_y = locations.ar_level.y
        end

        draw_inventory_text(projectile_levels["rifle bullet"], locations.ar_level.x, location_y, level_color)

        if level_color == DimWhite then
            Screen.fill_rect(locations.ar_level.x - adj(10), locations.ar_level.y + adj(6), adj(20), adj(2), DarkGray)
            local ratio = projectile_progress["rifle bullet"] / projectile_levelup_requirements["rifle bullet"]
            local width = math.ceil(ratio * 20)
            Screen.fill_rect(
                locations.ar_level.x - adj(10),
                locations.ar_level.y + adj(6),
                adj(width),
                adj(2),
                DimWhite
            )
        end
    end

    if p.items["smg ammo"].count > 0 or p.items["smg"].count > 0 then
        draw_inventory_text(p.items["smg ammo"].count, locations.smg_num.x, locations.smg_num.y, DimGreen)
        draw_item("smg", locations.smg_label.x, locations.smg_label.y, false)

        if p.items["smg"].count == 0 then
            draw_item("crossedout", locations.smg_label.x, locations.smg_label.y, true)
        end

        level_color = DimWhite
        location_y = locations.smg_level.y - adj(2)
        if projectile_levels["smg bullet"] == 10 then
            level_color = DimLightGold
            location_y = locations.smg_level.y
        end

        draw_inventory_text(projectile_levels["smg bullet"], locations.smg_level.x, location_y, level_color)

        if level_color == DimWhite then
            Screen.fill_rect(locations.smg_level.x - adj(10), locations.smg_level.y + adj(6), adj(20), adj(2), DarkGray)
            local ratio = projectile_progress["smg bullet"] / projectile_levelup_requirements["smg bullet"]
            local width = math.ceil(ratio * 20)
            Screen.fill_rect(
                locations.smg_level.x - adj(10),
                locations.smg_level.y + adj(6),
                adj(width),
                adj(2),
                DimWhite
            )
        end
    end

    if p.items["flamethrower ammo"].count > 0 or p.items["flamethrower"].count > 0 then
        draw_inventory_text(
            p.items["flamethrower ammo"].count,
            locations.flamethrower_num.x,
            locations.flamethrower_num.y,
            DimGreen
        )
        draw_item("flamethrower", locations.flamethrower_label.x, locations.flamethrower_label.y, false)

        if p.items["flamethrower"].count == 0 then
            draw_item("crossedout", locations.flamethrower_label.x, locations.flamethrower_label.y, true)
        end

        level_color = DimWhite
        location_y = locations.flamethrower_level.y - adj(2)
        if projectile_levels["flamethrower burst"] == 10 then
            level_color = DimLightGold
            location_y = locations.flamethrower_level.y
        end

        draw_inventory_text(
            projectile_levels["flamethrower burst"],
            locations.flamethrower_level.x,
            location_y,
            level_color
        )

        if level_color == DimWhite then
            Screen.fill_rect(
                locations.flamethrower_level.x - adj(10),
                locations.flamethrower_level.y + adj(6),
                adj(20),
                adj(2),
                DarkGray
            )
            local ratio =
                projectile_progress["flamethrower burst"] / projectile_levelup_requirements["flamethrower burst"]
            local width = math.ceil(ratio * 20)
            Screen.fill_rect(
                locations.flamethrower_level.x - adj(10),
                locations.flamethrower_level.y + adj(6),
                adj(width),
                adj(2),
                DimWhite
            )
        end
    end

    if p.items["missile launcher ammo"].count > 0 or p.items["missile launcher"].count > 0 then
        draw_inventory_text(
            p.items["missile launcher ammo"].count,
            locations.rocket_num.x,
            locations.rocket_num.y,
            DimGreen
        )
        draw_item("rl", locations.rocket_label.x, locations.rocket_label.y, false)

        if p.items["missile launcher"].count == 0 then
            draw_item("crossedout", locations.rocket_label.x, locations.rocket_label.y, true)
        end

        level_color = DimWhite
        location_y = locations.rocket_level.y - adj(2)
        if projectile_levels["missile"] == 10 then
            level_color = DimLightGold
            location_y = locations.rocket_level.y
        end

        draw_inventory_text(projectile_levels["missile"], locations.rocket_level.x, location_y, level_color)

        if level_color == DimWhite then
            Screen.fill_rect(
                locations.rocket_level.x - adj(10),
                locations.rocket_level.y + adj(6),
                adj(20),
                adj(2),
                DarkGray
            )
            local ratio = projectile_progress["missile"] / projectile_levelup_requirements["missile"]
            local width = math.ceil(ratio * 20)
            Screen.fill_rect(
                locations.rocket_level.x - adj(10),
                locations.rocket_level.y + adj(6),
                adj(width),
                adj(2),
                DimWhite
            )
        end
    end

    if p.items["alien weapon"].count > 0 then
        if p.items["alien weapon ammo"].count > 0 then
            draw_inventory_text(
                p.items["alien weapon ammo"].count,
                locations.alien_weapon_num.x,
                locations.alien_weapon_num.y,
                DimGreen
            )
        end
        draw_item("aw", locations.alien_weapon_label.x, locations.alien_weapon_label.y, false)

        level_color = DimWhite
        location_y = locations.alien_weapon_level.y - adj(2)
        if projectile_levels["alien weapon"] == 10 then
            level_color = DimLightGold
            location_y = locations.alien_weapon_level.y
        end

        draw_inventory_text(projectile_levels["alien weapon"], locations.alien_weapon_level.x, location_y, level_color)

        if level_color == DimWhite then
            Screen.fill_rect(
                locations.alien_weapon_level.x - adj(10),
                locations.alien_weapon_level.y + adj(6),
                adj(20),
                adj(2),
                DarkGray
            )
            local ratio = projectile_progress["alien weapon"] / projectile_levelup_requirements["alien weapon"]
            local width = math.ceil(ratio * 20)
            Screen.fill_rect(
                locations.alien_weapon_level.x - adj(10),
                locations.alien_weapon_level.y + adj(6),
                adj(width),
                adj(2),
                DimWhite
            )
        end
    end

    draw_item("energycan", locations.energy_can.x, locations.energy_can.y, true)
    draw_inventory_text(
        inventory_data.energy_can_count,
        locations.energy_can_label.x,
        locations.energy_can_label.y,
        InterfaceColors["computer yellow text"]
    )

    draw_item("chip", locations.chip.x, locations.chip.y, p.items["uplink chip"].count > 0)

    local class = get_stashed("class")
    local level = get_stashed_num("level")
    draw_class_info(class, level, inventory_data)

    if inventory_data.has_yellow_crystal then
        draw_item(
            YellowCrystalType .. "Small",
            locations.spell_yellow_crystal_image.x,
            locations.spell_yellow_crystal_image.y,
            false
        )
    end

    if inventory_data.ammo_selector_count > 0 then
        draw_inventory_text(
            inventory_data.ammo_selector_count,
            locations.spell_ammo_selector_status.x,
            locations.spell_ammo_selector_status.y,
            DimGreen
        )
        draw_item(
            AmmoSelectorType .. "Small",
            locations.spell_ammo_selector_image.x,
            locations.spell_ammo_selector_image.y,
            false
        )
    end

    if inventory_data.fury_timer > 0 then
        local ratio = inventory_data.fury_timer / fury_active_amount
        local width = math.ceil(ratio * locations.spell_fury_bar_status.width)

        Screen.fill_rect(
            locations.spell_fury_bar_status.x,
            locations.spell_fury_bar_status.y,
            width,
            locations.spell_fury_bar_status.height,
            InterfaceColors["computer yellow text"]
        )
        draw_item(FuryType .. "Small", locations.spell_fury_image.x, locations.spell_fury_image.y, true)
    elseif inventory_data.fury_count > 0 then
        draw_inventory_text(
            inventory_data.fury_count,
            locations.spell_fury_status.x,
            locations.spell_fury_status.y,
            DimGreen
        )

        draw_item(FuryType .. "Small", locations.spell_fury_image.x, locations.spell_fury_image.y, false)
    end

    if inventory_data.frozen_orb_count > 0 then
        draw_inventory_text(
            inventory_data.frozen_orb_count,
            locations.spell_frozen_orb_status.x,
            locations.spell_frozen_orb_status.y,
            DimGreen
        )
        draw_item(
            FrozenOrbType .. "Small",
            locations.spell_frozen_orb_image.x,
            locations.spell_frozen_orb_image.y,
            false
        )
    end

    if inventory_data.lightning_count > 0 then
        draw_inventory_text(
            inventory_data.lightning_count,
            locations.spell_lightning_status.x,
            locations.spell_lightning_status.y,
            DimGreen
        )
        draw_item(LightningType .. "Small", locations.spell_lightning_image.x, locations.spell_lightning_image.y, false)
    end

    if inventory_data.laser_count > 0 then
        draw_inventory_text(
            get_laser_display(inventory_data),
            locations.spell_laser_status.x,
            locations.spell_laser_status.y,
            DimGreen
        )
        draw_item(LaserType .. "Small", locations.spell_laser_image.x, locations.spell_laser_image.y, false)
    end

    if inventory_data.reflection_count > 0 then
        draw_inventory_text(
            inventory_data.reflection_count,
            locations.spell_reflection_status.x,
            locations.spell_reflection_status.y,
            DimGreen
        )
        draw_item(
            ReflectionType .. "Small",
            locations.spell_reflection_image.x,
            locations.spell_reflection_image.y,
            false
        )
    end

    if inventory_data.dispersal_dream_count > 0 then
        draw_inventory_text(
            inventory_data.dispersal_dream_count,
            locations.spell_dispersal_dream_status.x,
            locations.spell_dispersal_dream_status.y,
            DimGreen
        )
        draw_item(
            DispersalDreamType .. "Small",
            locations.spell_dispersal_dream_image.x,
            locations.spell_dispersal_dream_image.y,
            false
        )
    end

    if inventory_data.black_hole_count > 0 then
        draw_inventory_text(
            inventory_data.black_hole_count,
            locations.spell_black_hole_status.x,
            locations.spell_black_hole_status.y,
            DimGreen
        )
        draw_item(
            BlackHoleType .. "Small",
            locations.spell_black_hole_image.x,
            locations.spell_black_hole_image.y,
            false
        )
    end

    imgs["motion sensor"]:draw(locations.motion_sensor.x, locations.motion_sensor.y)
    local motion_sensor_length = imgs["motion sensor"].width
    for i = 1, #Player.motion_sensor.blips do
        local blip = Player.motion_sensor.blips[i - 1]
        local img = imgs["motion sensor " .. blip.type.mnemonic .. " " .. blip.intensity]

        local mult = (blip.distance / MotionSensorRange) * MotionSensorScale
        local rad = math.rad(blip.direction)
        local xoff = locations.motion_sensor.x + (motion_sensor_length / 2) + (math.cos(rad) * mult)
        local yoff = locations.motion_sensor.y + (motion_sensor_length / 2) + (math.sin(rad) * mult)

        img:draw(xoff - (img.width / 2), yoff - (img.height / 2))
    end

    local weppie = p.weapons.desired
    if weppie then
        -- selected
        local selected_image = nil
        local selected_x = nil
        local selected_y = nil
        local ammo1_count = nil
        local ammo2_count = nil
        if weppie.type == "fist" then
            selected_image = imgs["weppie selected 1"]
            selected_x = locations.fist_label.x
            selected_y = locations.fist_label.y
            draw_item("fist", locations.fist_label.x, locations.fist_label.y, true)
        elseif weppie.type == "pistol" then
            selected_image = imgs["weppie selected 1"]
            selected_x = locations.pistol_label.x
            selected_y = locations.pistol_label.y
            ammo1_count = p.items["pistol ammo"].count
            draw_inventory_text(p.items["pistol ammo"].count, locations.pistol_num.x, locations.pistol_num.y)
            draw_item("pistol", locations.pistol_label.x, locations.pistol_label.y, true)

            level_color = InterfaceColors["computer white text"]
            location_y = locations.pistol_level.y - adj(2)
            if projectile_levels["pistol bullet"] == 10 then
                level_color = LightGold
                location_y = locations.pistol_level.y
            end

            draw_inventory_text(projectile_levels["pistol bullet"], locations.pistol_level.x, location_y, level_color)

            if level_color == InterfaceColors["computer white text"] then
                Screen.fill_rect(
                    locations.pistol_level.x - adj(10),
                    locations.pistol_level.y + adj(6),
                    adj(20),
                    adj(2),
                    LightGray
                )
                local ratio = projectile_progress["pistol bullet"] / projectile_levelup_requirements["pistol bullet"]
                local width = math.ceil(ratio * 20)
                Screen.fill_rect(
                    locations.pistol_level.x - adj(10),
                    locations.pistol_level.y + adj(6),
                    adj(width),
                    adj(2),
                    InterfaceColors["computer white text"]
                )
            end
        elseif weppie.type == "fusion pistol" then
            selected_image = imgs["weppie selected 1"]
            selected_x = locations.fusion_label.x
            selected_y = locations.fusion_label.y
            ammo1_count = p.items["fusion pistol ammo"].count
            draw_inventory_text(p.items["fusion pistol ammo"].count, locations.fusion_num.x, locations.fusion_num.y)
            draw_item("fusion", locations.fusion_label.x, locations.fusion_label.y, true)

            level_color = InterfaceColors["computer white text"]
            location_y = locations.fusion_level.y - adj(2)
            if projectile_levels["fusion bolt minor"] == 10 then
                level_color = LightGold
                location_y = locations.fusion_level.y
            end

            draw_inventory_text(
                projectile_levels["fusion bolt minor"],
                locations.fusion_level.x,
                location_y,
                level_color
            )

            if level_color == InterfaceColors["computer white text"] then
                Screen.fill_rect(
                    locations.fusion_level.x - adj(10),
                    locations.fusion_level.y + adj(6),
                    adj(20),
                    adj(2),
                    LightGray
                )
                local ratio =
                    projectile_progress["fusion bolt minor"] / projectile_levelup_requirements["fusion bolt minor"]
                local width = math.ceil(ratio * 20)
                Screen.fill_rect(
                    locations.fusion_level.x - adj(10),
                    locations.fusion_level.y + adj(6),
                    adj(width),
                    adj(2),
                    InterfaceColors["computer white text"]
                )
            end
        elseif weppie.type == "shotgun" then
            selected_image = imgs["weppie selected 2"]
            selected_x = locations.shotgun_label.x - adj(18)
            selected_y = locations.shotgun_label.y
            ammo1_count = p.items["shotgun ammo"].count
            draw_inventory_text(p.items["shotgun ammo"].count, locations.shotgun_num.x, locations.shotgun_num.y)
            draw_item("shotgun", locations.shotgun_label.x, locations.shotgun_label.y, true)

            level_color = InterfaceColors["computer white text"]
            location_y = locations.shotgun_level.y - adj(2)
            if projectile_levels["shotgun bullet"] == 10 then
                level_color = LightGold
                location_y = locations.shotgun_level.y
            end

            draw_inventory_text(projectile_levels["shotgun bullet"], locations.shotgun_level.x, location_y, level_color)

            if level_color == InterfaceColors["computer white text"] then
                Screen.fill_rect(
                    locations.shotgun_level.x - adj(10),
                    locations.shotgun_level.y + adj(6),
                    adj(20),
                    adj(2),
                    LightGray
                )
                local ratio = projectile_progress["shotgun bullet"] / projectile_levelup_requirements["shotgun bullet"]
                local width = math.ceil(ratio * 20)
                Screen.fill_rect(
                    locations.shotgun_level.x - adj(10),
                    locations.shotgun_level.y + adj(6),
                    adj(width),
                    adj(2),
                    InterfaceColors["computer white text"]
                )
            end
        elseif weppie.type == "assault rifle" then
            selected_image = imgs["weppie selected 2"]
            selected_x = locations.ar_label.x - adj(18)
            selected_y = locations.ar_label.y
            ammo1_count = p.items["assault rifle ammo"].count
            ammo2_count = p.items["assault rifle grenades"].count
            draw_inventory_text(
                p.items["assault rifle ammo"].count .. "/" .. p.items["assault rifle grenades"].count,
                locations.ar_num.x,
                locations.ar_num.y
            )
            draw_item("ar", locations.ar_label.x, locations.ar_label.y, true)

            level_color = InterfaceColors["computer white text"]
            location_y = locations.ar_level.y - adj(2)
            if projectile_levels["rifle bullet"] == 10 then
                level_color = LightGold
                location_y = locations.ar_level.y
            end

            draw_inventory_text(projectile_levels["rifle bullet"], locations.ar_level.x, location_y, level_color)

            if level_color == InterfaceColors["computer white text"] then
                Screen.fill_rect(
                    locations.ar_level.x - adj(10),
                    locations.ar_level.y + adj(6),
                    adj(20),
                    adj(2),
                    LightGray
                )
                local ratio = projectile_progress["rifle bullet"] / projectile_levelup_requirements["rifle bullet"]
                local width = math.ceil(ratio * 20)
                Screen.fill_rect(
                    locations.ar_level.x - adj(10),
                    locations.ar_level.y + adj(6),
                    adj(width),
                    adj(2),
                    InterfaceColors["computer white text"]
                )
            end
        elseif weppie.type == "smg" then
            selected_image = imgs["weppie selected 2"]
            selected_x = locations.smg_label.x - adj(18)
            selected_y = locations.smg_label.y
            ammo1_count = p.items["smg ammo"].count
            draw_inventory_text(p.items["smg ammo"].count, locations.smg_num.x, locations.smg_num.y)
            draw_item("smg", locations.smg_label.x, locations.smg_label.y, true)

            level_color = InterfaceColors["computer white text"]
            location_y = locations.smg_level.y - adj(2)
            if projectile_levels["smg bullet"] == 10 then
                level_color = LightGold
                location_y = locations.smg_level.y
            end

            draw_inventory_text(projectile_levels["smg bullet"], locations.smg_level.x, location_y, level_color)

            if level_color == InterfaceColors["computer white text"] then
                Screen.fill_rect(
                    locations.smg_level.x - adj(10),
                    locations.smg_level.y + adj(6),
                    adj(20),
                    adj(2),
                    LightGray
                )
                local ratio = projectile_progress["smg bullet"] / projectile_levelup_requirements["smg bullet"]
                local width = math.ceil(ratio * 20)
                Screen.fill_rect(
                    locations.smg_level.x - adj(10),
                    locations.smg_level.y + adj(6),
                    adj(width),
                    adj(2),
                    InterfaceColors["computer white text"]
                )
            end
        elseif weppie.type == "flamethrower" then
            selected_image = imgs["weppie selected 3"]
            selected_x = locations.flamethrower_label.x
            selected_y = locations.flamethrower_label.y
            ammo1_count = p.items["flamethrower ammo"].count
            draw_inventory_text(
                p.items["flamethrower ammo"].count,
                locations.flamethrower_num.x,
                locations.flamethrower_num.y
            )
            draw_item("flamethrower", locations.flamethrower_label.x, locations.flamethrower_label.y, true)

            level_color = InterfaceColors["computer white text"]
            location_y = locations.flamethrower_level.y - adj(2)
            if projectile_levels["flamethrower burst"] == 10 then
                level_color = LightGold
                location_y = locations.flamethrower_level.y
            end

            draw_inventory_text(
                projectile_levels["flamethrower burst"],
                locations.flamethrower_level.x,
                location_y,
                level_color
            )

            if level_color == InterfaceColors["computer white text"] then
                Screen.fill_rect(
                    locations.flamethrower_level.x - adj(10),
                    locations.flamethrower_level.y + adj(6),
                    adj(20),
                    adj(2),
                    LightGray
                )
                local ratio =
                    projectile_progress["flamethrower burst"] / projectile_levelup_requirements["flamethrower burst"]
                local width = math.ceil(ratio * 20)
                Screen.fill_rect(
                    locations.flamethrower_level.x - adj(10),
                    locations.flamethrower_level.y + adj(6),
                    adj(width),
                    adj(2),
                    InterfaceColors["computer white text"]
                )
            end
        elseif weppie.type == "missile launcher" then
            selected_image = imgs["weppie selected 3"]
            selected_x = locations.rocket_label.x
            selected_y = locations.rocket_label.y
            ammo1_count = p.items["missile launcher ammo"].count
            draw_inventory_text(p.items["missile launcher ammo"].count, locations.rocket_num.x, locations.rocket_num.y)
            draw_item("rl", locations.rocket_label.x, locations.rocket_label.y, true)

            level_color = InterfaceColors["computer white text"]
            location_y = locations.rocket_level.y - adj(2)
            if projectile_levels["missile"] == 10 then
                level_color = LightGold
                location_y = locations.rocket_level.y
            end

            draw_inventory_text(projectile_levels["missile"], locations.rocket_level.x, location_y, level_color)

            if level_color == InterfaceColors["computer white text"] then
                Screen.fill_rect(
                    locations.rocket_level.x - adj(10),
                    locations.rocket_level.y + adj(6),
                    adj(20),
                    adj(2),
                    LightGray
                )
                local ratio = projectile_progress["missile"] / projectile_levelup_requirements["missile"]
                local width = math.ceil(ratio * 20)
                Screen.fill_rect(
                    locations.rocket_level.x - adj(10),
                    locations.rocket_level.y + adj(6),
                    adj(width),
                    adj(2),
                    InterfaceColors["computer white text"]
                )
            end
        elseif weppie.type == "alien weapon" then
            selected_image = imgs["weppie selected 3"]
            selected_x = locations.alien_weapon_label.x
            selected_y = locations.alien_weapon_label.y
            ammo1_count = p.items["alien weapon ammo"].count
            draw_inventory_text(
                p.items["alien weapon ammo"].count,
                locations.alien_weapon_num.x,
                locations.alien_weapon_num.y
            )
            draw_item("aw", locations.alien_weapon_label.x, locations.alien_weapon_label.y, true)

            level_color = InterfaceColors["computer white text"]
            location_y = locations.alien_weapon_level.y - adj(2)
            if projectile_levels["alien weapon"] == 10 then
                level_color = LightGold
                location_y = locations.alien_weapon_level.y
            end

            draw_inventory_text(
                projectile_levels["alien weapon"],
                locations.alien_weapon_level.x,
                location_y,
                level_color
            )

            if level_color == InterfaceColors["computer white text"] then
                Screen.fill_rect(
                    locations.alien_weapon_level.x - adj(10),
                    locations.alien_weapon_level.y + adj(6),
                    adj(20),
                    adj(2),
                    LightGray
                )
                local ratio = projectile_progress["alien weapon"] / projectile_levelup_requirements["alien weapon"]
                local width = math.ceil(ratio * 20)
                Screen.fill_rect(
                    locations.alien_weapon_level.x - adj(10),
                    locations.alien_weapon_level.y + adj(6),
                    adj(width),
                    adj(2),
                    InterfaceColors["computer white text"]
                )
            end
        end

        if selected_image then
            local x = selected_x - (selected_image.width / 2)
            local y = selected_y - (selected_image.height / 2)
            selected_image:draw(x, y)
        end

        -- name
        local ammo_center = (Screen.width / 2) - adj(115)
        local weppie_name = get_weppie_name(weppie)
        local w, h = fonts.small:measure_text(weppie_name)
        fonts.small:draw_text(weppie_name, ammo_center - (w / 2), Screen.height - adj(85), Green)

        -- ammo
        if weppie.primary then
            if weppie.primary.bullet_display then
                weapon_bullet_draw(weppie.primary)
            elseif weppie.primary.energy_display then
                weapon_energy_draw(weppie.primary)
            end
        end
        if weppie.secondary then
            if weppie.secondary.bullet_display then
                weapon_bullet_draw(weppie.secondary)
            elseif weppie.secondary.energy_display then
                weapon_energy_draw(weppie.secondary)
            end
        end
        if weppie_name == "A.W." then
            weapon_energy_draw(weppie.secondary)
        end

    -- Display ammo number in main box (unnecessary and it doesn't actually fit)
    -- if ammo1_count and not ammo2_count then
    --     draw_inventory_text(
    --         ammo1_count,
    --         locations.ammo1_only_label.x,
    --         locations.ammo1_only_label.y,
    --         InterfaceColors["computer dark green text"],
    --         fonts.tiny
    --     )
    -- elseif ammo2_count then
    --     draw_inventory_text(
    --         ammo1_count,
    --         locations.ammo1_label.x,
    --         locations.ammo1_label.y,
    --         InterfaceColors["computer dark green text"],
    --         fonts.tiny
    --     )
    --     draw_inventory_text(
    --         ammo2_count,
    --         locations.ammo2_label.x,
    --         locations.ammo2_label.y,
    --         InterfaceColors["computer dark green text"],
    --         fonts.tiny
    --     )
    -- end
    end

    if inventory_data.active_item then
        local x_offset = adj(-17)
        local y_offset = adj(-11)

        local item = inventory_data.active_item
        local selected_image = imgs["spell selected"]
        local selected_x = nil
        local selected_y = nil
        if item.type == YellowCrystalType then
            selected_x = locations.spell_yellow_crystal_status.x + x_offset
            selected_y = locations.spell_yellow_crystal_status.y + y_offset

            draw_item(
                YellowCrystalType .. "Small",
                locations.spell_yellow_crystal_image.x,
                locations.spell_yellow_crystal_image.y,
                true
            )
        elseif item.type == AmmoSelectorType then
            selected_x = locations.spell_ammo_selector_status.x + x_offset
            selected_y = locations.spell_ammo_selector_status.y + y_offset

            draw_inventory_text(
                inventory_data.ammo_selector_count,
                locations.spell_ammo_selector_status.x,
                locations.spell_ammo_selector_status.y
            )
            draw_item(
                AmmoSelectorType .. "Small",
                locations.spell_ammo_selector_image.x,
                locations.spell_ammo_selector_image.y,
                true
            )
        elseif item.type == FuryType then
            selected_x = locations.spell_fury_status.x + x_offset
            selected_y = locations.spell_fury_status.y + y_offset

            draw_inventory_text(inventory_data.fury_count, locations.spell_fury_status.x, locations.spell_fury_status.y)
            draw_item(FuryType .. "Small", locations.spell_fury_image.x, locations.spell_fury_image.y, true)
        elseif item.type == FrozenOrbType then
            selected_x = locations.spell_frozen_orb_status.x + x_offset
            selected_y = locations.spell_frozen_orb_status.y + y_offset

            draw_inventory_text(
                inventory_data.frozen_orb_count,
                locations.spell_frozen_orb_status.x,
                locations.spell_frozen_orb_status.y
            )
            draw_item(
                FrozenOrbType .. "Small",
                locations.spell_frozen_orb_image.x,
                locations.spell_frozen_orb_image.y,
                true
            )
        elseif item.type == LightningType then
            selected_x = locations.spell_lightning_status.x + x_offset
            selected_y = locations.spell_lightning_status.y + y_offset

            draw_inventory_text(
                inventory_data.lightning_count,
                locations.spell_lightning_status.x,
                locations.spell_lightning_status.y
            )
            draw_item(
                LightningType .. "Small",
                locations.spell_lightning_image.x,
                locations.spell_lightning_image.y,
                true
            )
        elseif item.type == LaserType then
            selected_x = locations.spell_laser_status.x + x_offset
            selected_y = locations.spell_laser_status.y + y_offset

            draw_inventory_text(
                get_laser_display(inventory_data),
                locations.spell_laser_status.x,
                locations.spell_laser_status.y
            )
            draw_item(LaserType .. "Small", locations.spell_laser_image.x, locations.spell_laser_image.y, true)
        elseif item.type == ReflectionType then
            selected_x = locations.spell_reflection_status.x + x_offset
            selected_y = locations.spell_reflection_status.y + y_offset

            draw_inventory_text(
                inventory_data.reflection_count,
                locations.spell_reflection_status.x,
                locations.spell_reflection_status.y
            )
            draw_item(
                ReflectionType .. "Small",
                locations.spell_reflection_image.x,
                locations.spell_reflection_image.y,
                true
            )
        elseif item.type == DispersalDreamType then
            selected_x = locations.spell_dispersal_dream_status.x + x_offset
            selected_y = locations.spell_dispersal_dream_status.y + y_offset

            draw_inventory_text(
                inventory_data.dispersal_dream_count,
                locations.spell_dispersal_dream_status.x,
                locations.spell_dispersal_dream_status.y
            )
            draw_item(
                DispersalDreamType .. "Small",
                locations.spell_dispersal_dream_image.x,
                locations.spell_dispersal_dream_image.y,
                true
            )
        elseif item.type == BlackHoleType then
            selected_x = locations.spell_black_hole_status.x + x_offset
            selected_y = locations.spell_black_hole_status.y + y_offset

            draw_inventory_text(
                inventory_data.black_hole_count,
                locations.spell_black_hole_status.x,
                locations.spell_black_hole_status.y
            )
            draw_item(
                BlackHoleType .. "Small",
                locations.spell_black_hole_image.x,
                locations.spell_black_hole_image.y,
                true
            )
        end

        if selected_x then
            selected_image:draw(selected_x, selected_y)
        end

        -- name
        local words = {}
        for substring in inventory_data.active_item.type:gmatch("%S+") do
            table.insert(words, substring)
        end
        draw_inventory_text(words[1], locations.spell.x, locations.spell.y, Green)

        if #words > 1 then
            draw_inventory_text(words[2], locations.spell.x, locations.spell.y + adj(17), Green)
        end

        -- image
        draw_item(inventory_data.active_item.type, locations.spell.x, locations.spell.y + adj(50), true)
    -- Unnecessary to show spell amount in this section
    -- if inventory_data.active_item.multiple then
    --     local active_item_count = inventory_data.active_item.count
    --     if inventory_data.active_item.type == LaserType then
    --         active_item_count = get_laser_display(inventory_data)
    --     end
    --     draw_inventory_text(
    --         active_item_count,
    --         locations.spell.x - adj(18),
    --         locations.spell.y + adj(50),
    --         InterfaceColors["computer dark green text"]
    --     )
    --     draw_item(inventory_data.active_item.type, locations.spell.x + adj(18), locations.spell.y + adj(50), true)
    -- else
    --     draw_item(inventory_data.active_item.type, locations.spell.x, locations.spell.y + adj(50), true)
    -- end
    end

    local collected_keys = get_stashed_table("collected_keys")
    if collected_keys["blue"] then
        draw_item("bluekey", locations.key_blue.x, locations.key_blue.y, true)
    end
    if collected_keys["gold"] then
        draw_item("goldkey", locations.key_gold.x, locations.key_gold.y, true)
    end
    if collected_keys["green"] then
        draw_item("greenkey", locations.key_green.x, locations.key_green.y, true)
    end
    if collected_keys["purple"] then
        draw_item("purplekey", locations.key_purple.x, locations.key_purple.y, true)
    end
    if collected_keys["red"] then
        draw_item("redkey", locations.key_red.x, locations.key_red.y, true)
    end
    if collected_keys["teal"] then
        draw_item("tealkey", locations.key_teal.x, locations.key_teal.y, true)
    end
    if collected_keys["violet"] then
        draw_item("violetkey", locations.key_violet.x, locations.key_violet.y, true)
    end
    if collected_keys["white"] then
        draw_item("whitekey", locations.key_white.x, locations.key_white.y, true)
    end
    if collected_keys["yellow"] then
        draw_item("yellowkey", locations.key_yellow.x, locations.key_yellow.y, true)
    end

    if class_selection == RocketClass then
        description = "Loves rockets. What more is there to say?"
        description2 = ""
        active, active2 = get_active_text(RocketClass)
        passive, passive2 = get_passive_text(RocketClass)
        difficulty = "Easy"
        draw_class_description(description, description2, active, active2, passive, passive2, difficulty)
    elseif class_selection == TimeClass then
        description = "A master of time. Can manipulate time to create an advantage over enemies."
        description2 = ""
        active, active2 = get_active_text(TimeClass)
        passive, passive2 = get_passive_text(TimeClass)
        difficulty = "Medium"
        draw_class_description(description, description2, active, active2, passive, passive2, difficulty)
    elseif class_selection == MindControlClass then
        description = "Has incredible influence over all living things, even the fiercest enemies."
        description2 = ""
        active, active2 = get_active_text(MindControlClass)
        passive, passive2 = get_passive_text(MindControlClass)
        difficulty = "Medium"
        draw_class_description(description, description2, active, active2, passive, passive2, difficulty)
    elseif class_selection == ForceClass then
        description = "Can move objects without touching them."
        description2 = ""
        active, active2 = get_active_text(ForceClass)
        passive, passive2 = get_passive_text(ForceClass)
        difficulty = "Hard"
        draw_class_description(description, description2, active, active2, passive, passive2, difficulty)
    elseif class_selection == FusionClass then
        description = "Understands the technology behind fusion pistols far greater than anyone else."
        description2 = "Also has some violent tendencies. A great combination."
        active, active2 = get_active_text(FusionClass)
        passive, passive2 = get_passive_text(FusionClass)
        difficulty = "Easy"
        draw_class_description(description, description2, active, active2, passive, passive2, difficulty)
    elseif class_selection == RifleClass then
        description = "A real gun nut. This is who you call when you need a sniper in the middle of the night."
        description2 = ""
        active, active2 = get_active_text(RifleClass)
        passive, passive2 = get_passive_text(RifleClass)
        difficulty = "Medium"
        draw_class_description(description, description2, active, active2, passive, passive2, difficulty)
    elseif class_selection == PyroClass then
        description =
            "You all knew that kid who called themself a pyro and stared at some tiny flame and thought it was cool."
        description2 = "The pyrotechnic burned that kid alive."
        active, active2 = get_active_text(PyroClass)
        passive, passive2 = get_passive_text(PyroClass)
        difficulty = "Easy"
        draw_class_description(description, description2, active, active2, passive, passive2, difficulty)
    elseif class_selection == MeleeClass then
        description = "Melee class. Has the ability to use weapons like usual, but is happiest punching things."
        description2 = ""
        active, active2 = get_active_text(MeleeClass)
        passive, passive2 = get_passive_text(MeleeClass)
        difficulty = "Hard"
        draw_class_description(description, description2, active, active2, passive, passive2, difficulty)
    end

    local inventory_item = get_stashed("inventory_item_id")
    if inventory_item then
        local image_type, lines = get_inventory_info(inventory_item)
        if image_type then
            local text_color = {.8, .8, .8}
            local rectx = Screen.width / 2 - Screen.width / 5
            local recty = Screen.height / 8
            local rectwidth = Screen.width / 2.1
            local rectheight = Screen.height * .22
            Screen.fill_rect(rectx, recty, rectwidth, rectheight, Black)
            Screen.frame_rect(rectx, recty, rectwidth, rectheight, Gray, Screen.width / 640)
            draw_item(image_type, rectx + rectwidth / 12, recty + rectheight / 2, true)
            local textx = rectx + rectwidth / 6
            local texty = recty + rectheight / 8
            title = inventory_item
            local _, font_height = fonts.small:measure_text(title)
            fonts.small:draw_text(title, textx, texty, text_color)
            texty = texty + 2 * font_height
            for i = 1, #lines do
                fonts.small:draw_text(lines[i], textx, texty, text_color)
                texty = texty + font_height
            end
        end
    end
end -- end draw

function get_active_text(classType)
    local active = ""
    local active2 = ""
    if classType == RocketClass then
        active = "Fire homing rockets when the class ability is active."
        active2 = ""
    elseif classType == MeleeClass then
        active = "Launch forward with secondary fire, causing high damage punches if timed correctly."
        active2 = ""
    elseif classType == TimeClass then
        active = "Briefly stops time for everyone but the player. Everything else is frozen in place."
        active2 = ""
    elseif classType == MindControlClass then
        active = "Temporarily dominate the mind of a single target, forcing them to fight alongside you."
        active2 = ""
    elseif classType == ForceClass then
        active = "Mentally shoves monsters in front of the player, interrupting their attacks and knocking them back."
        active2 = "Non-player projectiles in front of the player are also shoved in the reverse direction."
    elseif classType == FusionClass then
        active = "Briefly turns all regular fusion bolts fired into seeking charged bolts."
        active2 = ""
    elseif classType == RifleClass then
        active = "Assault rifle grenade detonations pull enemies toward the detonation site."
        active2 = "SMG bullets are highly accurate and impact their targets instantly."
    elseif classType == PyroClass then
        active = "The flamethrower flame extends an infinite range and impacts the target instantly."
        active2 = "Alien weapons shoot bursts of 3 projectiles instead of 1."
    end

    return active, active2
end

function get_passive_text(classType)
    local passive = ""
    local passive2 = ""
    if classType == RocketClass then
        passive = "Rocket detonations have a larger area of effect that increases with player level."
        passive2 = "Receives extra rockets from Ammo Selectors."
    elseif classType == MeleeClass then
        passive =
            "Deals slightly more damage to the punched monster, as well as nearby monsters. If there are no nearby"
        passive2 =
            "monsters, it will do quite a bit more damage to the punched monster. Damage increases with player level."
    elseif classType == TimeClass then
        passive = "The player's projectiles move faster. The speed increases with player level."
        passive2 = ""
    elseif classType == MindControlClass then
        passive = "Each time a monster is hit by the projectile of another monster, it takes increased damage."
        passive2 = "The friendly fire damage increases with player level."
    elseif classType == ForceClass then
        passive = "Has a chance to reflect incoming enemy projectiles back toward the owner."
        passive2 = "The chance to reflect increases with player level."
    elseif classType == FusionClass then
        passive = "When a fusion bolt impacts an enemy, there is a chance it will continue to a nearby enemy."
        passive2 = "The chance of this happening increases with player level."
    elseif classType == RifleClass then
        passive =
            "Monsters hit with grenades subsequently take additional damage from attacks. SMG bullets have a chance"
        passive2 = "to pass through monsters. Additional damage and passthrough chance increase with player level."
    elseif classType == PyroClass then
        passive = "Flame damage bypasses flame immunity in enemies. Flame damage is also less effective against"
        passive2 = "the pyrotechnic. Flame damage mitigation increases with player level."
    end

    return passive, passive2
end

function get_inventory_info(t)
    if t == HealthType then
        return "energycan", message_to_lines(get_description_energy_can(), 60)
    elseif t == LaserType then
        return LaserType, message_to_lines(get_description_laser(), 60)
    elseif t == LightningType then
        return LightningType, message_to_lines(get_description_lightning(), 60)
    elseif t == DispersalDreamType then
        return DispersalDreamType, message_to_lines(get_description_dispersal_dream(), 60)
    elseif t == FrozenOrbType then
        return FrozenOrbType, message_to_lines(get_description_frozen_orb(), 60)
    elseif t == FuryType then
        return FuryType, message_to_lines(get_description_fury(), 60)
    elseif t == ReflectionType then
        return ReflectionType, message_to_lines(get_description_reflection(), 60)
    elseif t == BlackHoleType then
        return BlackHoleType, message_to_lines(get_description_black_hole(), 60)
    elseif t == AmmoSelectorType then
        return AmmoSelectorType, message_to_lines(get_description_ammo_selector(), 60)
    elseif t == YellowCrystalType then
        return YellowCrystalType, message_to_lines(get_description_yellow_crystal(), 60)
    elseif t == BeackpeackType then
        return BeackpeackType, message_to_lines(get_description_beackpeack(), 60)
    elseif t == "Blue Key" then
        return "bluekey", {"Opens blue doors."}
    elseif t == "Gold Key" then
        return "goldkey", {"Opens gold doors."}
    elseif t == "Green Key" then
        return "greenkey", {"Opens green doors."}
    elseif t == "Purple Key" then
        return "purplekey", {"Opens purple doors."}
    elseif t == "Red Key" then
        return "redkey", {"Opens red doors."}
    elseif t == "Teal Key" then
        return "tealkey", {"Opens teal doors."}
    elseif t == "Violet Key" then
        return "violetkey", {"Opens violet doors."}
    elseif t == "White Key" then
        return "whitekey", {"Opens white doors."}
    elseif t == "Yellow Key" then
        return "yellowkey", {"Opens yellow doors."}
    end
    return nil, nil, nil, nil
end

function get_description_energy_can()
    local hotkey_bindings = get_stashed_table("hotkey_bindings")
    return "Energy can that can be used to recharge your shield on demand. Press the following key to activate: " ..
        hotkey_bindings[12]
end

function get_description_laser()
    return "Channeled spell that instantly makes contact with whatever is directly in the player's view, regardless of distance. The ammo value indicates the number of seconds remaining."
end

function get_description_lightning()
    return "Lightning strikes from above the targeted monster. The targeted monster will have a red crosshair drawn on top of it when the spell is selected. Lightning strikes damage the surrounding area and are especially effective against tightly clumped groups of monsters."
end

function get_description_dispersal_dream()
    return "Spell that causes chain explosions starting at the targeted monster. Ground targets only. After each explosion, it will continue to the next non-flying monster if one is close enough. The targeted monster will have a red crosshair drawn on top of it when the spell is selected."
end

function get_description_frozen_orb()
    return "Spell that creates a slow moving, short range ball of ice that passes through monsters. Smaller ice spikes fire from the ice ball in all directions, causing damage and temporarily slowing monsters that are hit. Slowed monsters are marked with a symbol above their head, and their projectiles are also slowed."
end

function get_description_fury()
    return "Short lasting spell that doubles all damage from conventional weapons while active. When killed, monsters explode into gore."
end

function get_description_reflection()
    return "A spell that reflects any enemy projectiles back toward the monster that fired it. Only projectiles in the air at the time the spell is used are affected."
end

function get_description_black_hole()
    return "A very powerful spell that creates a black hole above the target location. It is best to target the ground where the black hole should appear. A brief charge period is needed for the black hole to gain power after activation. Once charged, all monsters in the area are pulled toward the black hole and killed when the spell ends."
end

function get_description_ammo_selector()
    return "A spell that adds to any ammo you have previously found. Can be used on one type of ammo per spell use."
end

function get_description_yellow_crystal()
    return "This is a strange crystal that seems to hum in your hand. Activating it while standing over a body of a dead human provides an opportunity to communicate with the spirit of the slain person. This only works if the spirit is restless or has unfinished business of some kind."
end

function get_description_beackpeack()
    return "A simple bag that attaches to your belt. You can use it to carry more spells at once."
end

function message_to_lines(message, numchars)
    local words = {}
    for word in string.gmatch(message, "[^%s]+") do
        table.insert(words, word)
    end

    local lines = {}
    local line = ""
    for _, v in ipairs(words) do
        if string.len(line) + string.len(v) < numchars then
            if line == "" then
                line = v
            else
                line = line .. " " .. v
            end
        else
            table.insert(lines, line)
            line = v
        end
    end

    table.insert(lines, line)
    return lines
end

function draw_class_description(description, description2, active, active2, passive, passive2, difficulty)
    local info_font = fonts.small
    local title_color = White
    local info_color = LighterGray
    local _, font_height = info_font:measure_text(description)
    local hotkey_bindings = get_stashed_table("hotkey_bindings")

    y = Screen.height / 6
    info_font:draw_text("Description:", Screen.width / 3, y, title_color)
    y = y + font_height + 5
    info_font:draw_text(description, Screen.width / 3, y, info_color)
    y = y + font_height + 5
    info_font:draw_text(description2, Screen.width / 3, y, info_color)
    y = y + font_height + 15
    info_font:draw_text("Active Skill:", Screen.width / 3, y, title_color)
    y = y + font_height + 5
    info_font:draw_text(active, Screen.width / 3, y, info_color)
    y = y + font_height + 5
    info_font:draw_text(active2, Screen.width / 3, y, info_color)
    y = y + font_height + 15
    info_font:draw_text("Passive Ability:", Screen.width / 3, y, title_color)
    y = y + font_height + 5
    info_font:draw_text(passive, Screen.width / 3, y, info_color)
    y = y + font_height + 5
    info_font:draw_text(passive2, Screen.width / 3, y, info_color)

    y = y + font_height + 40

    info_font:draw_text("Note: Certain extra keys must be set for this scenario!", Screen.width / 3, y, Red)
    y = y + font_height + 25
    hotkey10_label = "Hotkey 10 - Active Skill: "
    local fw, _ = info_font:measure_text(hotkey10_label)
    info_font:draw_text(hotkey10_label, Screen.width / 3, y, title_color)
    info_font:draw_text(hotkey_bindings[10], Screen.width / 3 + fw, y, Green)

    y = y + font_height + 5
    hotkey11_label = "Hotkey 11 - Cast spell: "
    local fw, _ = info_font:measure_text(hotkey11_label)
    info_font:draw_text(hotkey11_label, Screen.width / 3, y, title_color)
    info_font:draw_text(hotkey_bindings[11], Screen.width / 3 + fw, y, Green)

    y = y + font_height + 5
    hotkey12_label = "Hotkey 12 - Use energy can to heal: "
    local fw, _ = info_font:measure_text(hotkey12_label)
    info_font:draw_text(hotkey12_label, Screen.width / 3, y, title_color)
    info_font:draw_text(hotkey_bindings[12], Screen.width / 3 + fw, y, Green)

    y = y + font_height + 5
    hotkey12_label = "Aux trigger - Hold to cycle through spells, and loot bodies."
    info_font:draw_text(hotkey12_label, Screen.width / 3, y, title_color)
end

function read_inventory(inventory)
    local data = {
        energy_can_count = 0,
        freeze_max_cooldown = 0,
        freeze_cooldown = 0,
        freeze_active_amount = 0,
        mind_control_max_cooldown = 0,
        mind_control_cooldown = 0,
        mind_control_active_amount = 0,
        shove_max_cooldown = 0,
        shove_cooldown = 0,
        homing_missiles_max_cooldown = 0,
        homing_missiles_cooldown = 0,
        homing_missiles_active_amount = 0,
        rush_max_cooldown = 0,
        rush_cooldown = 0,
        rush_active_amount = 0,
        charged_bolts_max_cooldown = 0,
        charged_bolts_cooldown = 0,
        charged_bolts_active_amount = 0,
        grenade_pull_max_cooldown = 0,
        grenade_pull_cooldown = 0,
        grenade_pull_active_amount = 0,
        hitscan_flame_max_cooldown = 0,
        hitscan_flame_cooldown = 0,
        hitscan_flame_active_amount = 0,
        has_yellow_crystal = false,
        ammo_selector_count = 0,
        fury_count = 0,
        frozen_orb_count = 0,
        lightning_count = 0,
        laser_count = 0,
        reflection_count = 0,
        dispersal_dream_count = 0,
        black_hole_count = 0
    }

    data.active_item = get_stashed_table("active_item")
    data.freeze_timer = get_stashed_num("freeze_timer")
    data.fury_timer = get_stashed_num("fury_timer")
    data.slow_timer = get_stashed_num("slow_timer")
    data.mind_control_timer = get_stashed_num("mind_control_timer")
    data.homing_missiles_timer = get_stashed_num("homing_missiles_timer")
    data.rush_timer = get_stashed_num("rush_timer")
    data.charged_bolts_timer = get_stashed_num("charged_bolts_timer")
    data.grenade_pull_timer = get_stashed_num("grenade_pull_timer")
    data.hitscan_flame_timer = get_stashed_num("hitscan_flame_timer")

    fury_active_amount = 15 * 30

    for _, v in ipairs(inventory) do
        if v.type == HealthType then
            data.energy_can_count = v.count
        elseif v.type == FreezeTimeType then
            data.freeze_max_cooldown = v.cooldown_amount
            data.freeze_cooldown = v.current_cooldown
            data.freeze_active_amount = v.active_amount
        elseif v.type == MindControlType then
            data.mind_control_max_cooldown = v.cooldown_amount
            data.mind_control_cooldown = v.current_cooldown
            data.mind_control_active_amount = v.active_amount
        elseif v.type == HomingMissilesType then
            data.homing_missiles_max_cooldown = v.cooldown_amount
            data.homing_missiles_cooldown = v.current_cooldown
            data.homing_missiles_active_amount = v.active_amount
        elseif v.type == RushType then
            data.rush_max_cooldown = v.cooldown_amount
            data.rush_cooldown = v.current_cooldown
            data.rush_active_amount = v.active_amount
        elseif v.type == ChargedBoltsType then
            data.charged_bolts_max_cooldown = v.cooldown_amount
            data.charged_bolts_cooldown = v.current_cooldown
            data.charged_bolts_active_amount = v.active_amount
        elseif v.type == GrenadePullType then
            data.grenade_pull_max_cooldown = v.cooldown_amount
            data.grenade_pull_cooldown = v.current_cooldown
            data.grenade_pull_active_amount = v.active_amount
        elseif v.type == HitscanFlameType then
            data.hitscan_flame_max_cooldown = v.cooldown_amount
            data.hitscan_flame_cooldown = v.current_cooldown
            data.hitscan_flame_active_amount = v.active_amount
        elseif v.type == ShoveType then
            data.shove_max_cooldown = v.cooldown_amount
            data.shove_cooldown = v.current_cooldown
        elseif v.type == YellowCrystalType then
            data.has_yellow_crystal = true
        elseif v.type == AmmoSelectorType then
            data.ammo_selector_count = v.count
        elseif v.type == FuryType then
            data.fury_count = v.count
        elseif v.type == FrozenOrbType then
            data.frozen_orb_count = v.count
        elseif v.type == LightningType then
            data.lightning_count = v.count
        elseif v.type == LaserType then
            data.laser_count = v.count
        elseif v.type == ReflectionType then
            data.reflection_count = v.count
        elseif v.type == DispersalDreamType then
            data.dispersal_dream_count = v.count
        elseif v.type == BlackHoleType then
            data.black_hole_count = v.count
        end
    end

    return data
end

function get_weppie_name(weppie)
    local type = weppie.type
    if type == "fist" then
        return "Fist"
    elseif type == "pistol" then
        return "Magnum"
    elseif type == "fusion pistol" then
        return "Fusion"
    elseif type == "assault rifle" then
        return "MA-75B"
    elseif type == "missile launcher" then
        return "SPNKR"
    elseif type == "flamethrower" then
        return "TOZT"
    elseif type == "alien weapon" then
        return "A.W."
    elseif type == "shotgun" then
        return "WSTE-M"
    elseif type == "smg" then
        return "SMG"
    end

    return "Ball"
end

function draw_class_info(class, level, inv)
    if class then
        draw_inventory_text(
            class,
            locations.class_label.x,
            locations.class_label.y,
            InterfaceColors["computer white text"],
            fonts.tiny
        )

        if class == RocketClass then
            display_class_cooldown_info(
                level,
                "Homing",
                "Missiles",
                inv.homing_missiles_timer,
                inv.homing_missiles_active_amount,
                inv.homing_missiles_cooldown,
                inv.homing_missiles_max_cooldown,
                fonts.tiny
            )
        elseif class == MeleeClass then
            display_class_cooldown_info(
                level,
                "Rush",
                "",
                inv.rush_timer,
                inv.rush_active_amount,
                inv.rush_cooldown,
                inv.rush_max_cooldown
            )
        elseif class == TimeClass then
            display_class_cooldown_info(
                level,
                "Freeze",
                "Time",
                inv.freeze_timer,
                inv.freeze_active_amount,
                inv.freeze_cooldown,
                inv.freeze_max_cooldown
            )
        elseif class == MindControlClass then
            display_class_cooldown_info(
                level,
                "Mind",
                "Control",
                inv.mind_control_timer,
                inv.mind_control_active_amount,
                inv.mind_control_cooldown,
                inv.mind_control_max_cooldown
            )
        elseif class == ForceClass then
            display_class_cooldown_info(level, "Shove", nil, nil, nil, inv.shove_cooldown, inv.shove_max_cooldown)
        elseif class == FusionClass then
            display_class_cooldown_info(
                level,
                "Charged",
                "Bolts",
                inv.charged_bolts_timer,
                inv.charged_bolts_active_amount,
                inv.charged_bolts_cooldown,
                inv.charged_bolts_max_cooldown
            )
        elseif class == RifleClass then
            display_class_cooldown_info(
                level,
                "AR/SMG",
                "Skill",
                inv.grenade_pull_timer,
                inv.grenade_pull_active_amount,
                inv.grenade_pull_cooldown,
                inv.grenade_pull_max_cooldown
            )
        elseif class == PyroClass then
            display_class_cooldown_info(
                level,
                "Throw",
                "Flame",
                inv.hitscan_flame_timer,
                inv.hitscan_flame_active_amount,
                inv.hitscan_flame_cooldown,
                inv.hitscan_flame_max_cooldown
            )
        end
    end
end

function display_class_cooldown_info(level, spell_name1, spell_name2, timer, active_amount, cooldown, max_cooldown)
    local levelup_progress = get_stashed("levelup_progress")
    local levelup_requirement = get_stashed("levelup_requirement")
    draw_inventory_text(
        "Lv " .. level,
        locations.level_with_cooldown.x,
        locations.level_with_cooldown.y - adj(2),
        InterfaceColors["computer white text"],
        fonts.tiny
    )
    Screen.fill_rect(
        locations.level_with_cooldown.x - adj(20),
        locations.level_with_cooldown.y + adj(5),
        adj(40),
        adj(2),
        LightGray
    )
    local ratio = levelup_progress / levelup_requirement
    local width = math.ceil(ratio * 40)
    Screen.fill_rect(
        locations.level_with_cooldown.x - adj(20),
        locations.level_with_cooldown.y + adj(5),
        adj(width),
        adj(2),
        InterfaceColors["computer white text"]
    )

    draw_inventory_text(
        spell_name1,
        locations.class_description_with_cooldown1.x,
        locations.class_description_with_cooldown1.y,
        InterfaceColors["computer text"],
        fonts.tiny
    )
    if spell_name2 then
        draw_inventory_text(
            spell_name2,
            locations.class_description_with_cooldown2.x,
            locations.class_description_with_cooldown2.y,
            InterfaceColors["computer text"],
            fonts.tiny
        )
    end

    if timer and timer > 0 then
        draw_inventory_text(
            math.ceil(timer / 30) .. "s",
            locations.class_cooldown_label.x,
            locations.class_cooldown_label.y,
            InterfaceColors["computer yellow text"],
            fonts.tiny
        )

        local ratio = timer / active_amount
        local width = math.ceil(ratio * locations.class_cooldown.width)

        Screen.fill_rect(
            locations.class_cooldown.x,
            locations.class_cooldown.y,
            width,
            locations.class_cooldown.height,
            InterfaceColors["computer yellow text"]
        )
    elseif cooldown > 0 then
        draw_inventory_text(
            math.ceil(cooldown / 30) .. "s",
            locations.class_cooldown_label.x,
            locations.class_cooldown_label.y,
            InterfaceColors["computer red text"],
            fonts.tiny
        )

        -- This formula needs to be synced up with the embedded lua
        local decrease_amount = (.04 * max_cooldown) * level
        local min_cooldown = .05 * max_cooldown
        local max_current_cooldown = math.max(min_cooldown, math.ceil(max_cooldown - decrease_amount))

        local ratio = cooldown / max_current_cooldown
        local width = locations.class_cooldown.width - (math.ceil(ratio * locations.class_cooldown.width))

        Screen.fill_rect(
            locations.class_cooldown.x,
            locations.class_cooldown.y,
            width,
            locations.class_cooldown.height,
            InterfaceColors["computer red text"]
        )
    else
        draw_inventory_text(
            "Rdy",
            locations.class_cooldown_label.x,
            locations.class_cooldown_label.y,
            InterfaceColors["computer text"],
            fonts.tiny
        )

        Screen.fill_rect(
            locations.class_cooldown.x,
            locations.class_cooldown.y,
            locations.class_cooldown.width,
            locations.class_cooldown.height,
            {.035, .97, .984, class_ready_alpha_levels[Game.ticks % 60]}
        )
    end
end

function draw_inventory_text(text, x, y, color, font)
    local f = fonts.small
    if font then
        f = font
    end
    local w, h = f:measure_text(text)
    local drawx = x - (w / 2)
    local drawy = y - (h / 2)
    if not color then
        color = InterfaceColors["computer text"]
    end
    f:draw_text(text, drawx, drawy, color)
end

function resize_image(image)
    local w = adj(image.width)
    local h = adj(image.height)
    image:rescale(w, h)
end

function resize_inventory_image(image)
    local ratio = image.width / image.height
    local height = adj(20)
    local width = math.floor((height * ratio) + 0.5)
    if width > adj(50) then
        width = adj(50)
        height = math.floor((width / ratio))
    end
    image:rescale(width, height)
end

function resize_recently_equipped_image(image)
    local ratio = image.width / image.height
    local height = adj(65)
    local width = math.floor((height * ratio) + 0.5)
    image:rescale(width, height)
end

function draw_item(type, x, y, bright)
    local image = imgs[type]
    if bright then
        image.tint_color = {1, 1, 1, 1}
    else
        image.tint_color = {1, 1, 1, 0.3}
    end
    image:draw(x - (image.width / 2), y - (image.height / 2))
end

function weapon_bullet_draw(trigger)
    local p = Player
    local disp = trigger.bullet_display
    local rounds = trigger.rounds
    if rounds < 0 then
        rounds = 0
    end
    local max = disp.across * disp.down
    if rounds > max then
        rounds = max
    end

    local dr = {}

    if trigger.ammo_type == "pistol ammo" then
        if trigger.bullet_display.right_to_left then
            if p.items["pistol"].count < 2 then
                return
            end

            dr = {
                x = (Screen.width / 2) - adj(149),
                y = (Screen.height) - adj(34),
                width = adj(disp.width),
                height = adj(disp.height)
            }
        else
            dr = {
                x = (Screen.width / 2) - adj(139),
                y = (Screen.height) - adj(54),
                width = adj(disp.width),
                height = adj(disp.height)
            }
        end
    elseif trigger.ammo_type == "shotgun ammo" then
        dr = {
            x = (Screen.width / 2) + adj(disp.x) - adj(602),
            y = (Screen.height) - adj(45),
            width = adj(disp.width),
            height = adj(disp.height)
        }
    elseif trigger.ammo_type == "assault rifle ammo" then
        dr = {
            x = (Screen.width / 2) - adj(150),
            y = (Screen.height) - adj(63),
            width = adj(disp.width),
            height = adj(disp.height)
        }
    elseif trigger.ammo_type == "assault rifle grenades" then
        dr = {
            x = (Screen.width / 2) - adj(152),
            y = (Screen.height) - adj(20),
            width = adj(disp.width),
            height = adj(disp.height)
        }
    elseif trigger.ammo_type == "smg ammo" then
        dr = {
            x = (Screen.width / 2) - adj(144),
            y = (Screen.height) - adj(57),
            width = adj(disp.width),
            height = adj(disp.height)
        }
    elseif trigger.ammo_type == "missile launcher ammo" then
        dr = {
            x = (Screen.width / 2) - adj(139),
            y = (Screen.height) - adj(62),
            width = adj(disp.width),
            height = adj(disp.height)
        }
    elseif trigger.ammo_type == "alien weapon ammo" then
        dr = {
            x = (Screen.width / 2) - adj(138),
            y = (Screen.height) - adj(60),
            width = adj(disp.width),
            height = adj(disp.height)
        }
    end

    local full = ammo_shapes[disp.texture_index]
    if not full then
        return
    end
    local empty = ammo_shapes[disp.empty_texture_index]
    if not empty then
        return
    end

    dr.x = dr.x + adj(10)

    local row = 0
    full.crop_rect.x = 0
    full.crop_rect.width = full.width
    while row < math.floor(rounds / disp.across) do
        full:draw(dr.x, dr.y)
        dr.y = dr.y + dr.height
        row = row + 1
    end

    local partial = rounds % disp.across
    if partial > 0 then
        full.crop_rect.width = partial * dr.width
        empty.crop_rect.width = (disp.across - partial) * dr.width
        if disp.right_to_left then
            full.crop_rect.x = 0
            full:draw(dr.x, dr.y)
            empty.crop_rect.x = full.crop_rect.width
            empty:draw(dr.x + empty.crop_rect.x, dr.y)
        else
            empty.crop_rect.x = 0
            empty:draw(dr.x, dr.y)
            full.crop_rect.x = empty.crop_rect.width
            full:draw(dr.x + full.crop_rect.x, dr.y)
        end
        dr.y = dr.y + dr.height
    end

    row = 0
    empty.crop_rect.x = 0
    empty.crop_rect.width = empty.width
    while row < math.floor((max - rounds) / disp.across) do
        empty:draw(dr.x, dr.y)
        dr.y = dr.y + dr.height
        row = row + 1
    end
end

function weapon_energy_draw(trigger)
    local disp = trigger.energy_display
    if not disp then -- alien weapon
        fus_disp = Player.weapons["fusion pistol"].primary.energy_display
        disp = {
            maximum = 45,
            width = fus_disp.width,
            height = fus_disp.height,
            color = fus_disp.color,
            empty_color = fus_disp.empty_color
        }
    end
    local rounds = trigger.rounds
    if rounds < 0 then
        return
    end
    if rounds > disp.maximum then
        rounds = disp.maximum
    end

    local dr = {
        x = (Screen.width / 2) - adj(133),
        y = (Screen.height) - adj(65),
        width = adj(disp.width),
        height = adj(disp.height)
    }

    Screen.fill_rect(dr.x, dr.y, dr.width, dr.height, disp.color)

    local fill_height = math.floor((rounds * dr.height) / disp.maximum)
    Screen.fill_rect(dr.x, dr.y, dr.width, dr.height - fill_height, disp.empty_color)
end

function get_oxygen_percent()
    local percent = (Player.oxygen / 10800) * 100
    if percent < 0 then
        percent = 0
    elseif percent > 100 then
        percent = 100
    end
    return math.ceil(percent)
end

function get_percent_color(percent)
    local color = InterfaceColors["computer text"]
    local name = "green"
    if percent <= .33 then
        color = InterfaceColors["computer red text"]
        name = "red"
    elseif percent <= .66 then
        color = InterfaceColors["computer yellow text"]
        name = "yellow"
    end
    return color, name
end

function Triggers.resize()
    load_images()
    resize_images()

    fonts = {
        tiny = Fonts.new {id = 22, size = adj(10), style = 1},
        smaller = Fonts.new {id = 22, size = adj(13), style = 1},
        small = Fonts.new {id = 22, size = adj(15), style = 1},
        medium = Fonts.new {id = 22, size = adj(22), style = 1},
        big = Fonts.new {id = 22, size = adj(30), style = 1}
    }

    Screen.world_rect.x = 0
    Screen.world_rect.y = 0
    Screen.world_rect.width = Screen.width
    Screen.world_rect.height = Screen.height - adj(90)

    Screen.map_rect.x = 0
    Screen.map_rect.y = 0
    Screen.map_rect.width = Screen.width
    Screen.map_rect.height = Screen.height - adj(90)

    Screen.text_margins.left = adj(180)

    Screen.term_rect.height = 320
    if Screen.term_size_preference == "double" and Screen.width >= 1280 and (Screen.height - adj(150)) >= 640 then
        Screen.term_rect.height = 640
    elseif Screen.term_size_preference == "largest" then
        Screen.term_rect.height = Screen.height - adj(150)
    end

    Screen.term_rect.width = Screen.term_rect.height * 2

    if Screen.term_rect.width > Screen.width then
        Screen.term_rect.width = Screen.width
        Screen.term_rect.height = Screen.term_rect.width / 2
    end

    Screen.term_rect.y = math.floor(((Screen.height - adj(150)) / 2) - (Screen.term_rect.height / 2))
    Screen.term_rect.x = math.floor((Screen.width - Screen.term_rect.width) / 2)

    local sw = Screen.width
    local sh = Screen.height

    local center = sw / 2

    local row1 = sh - adj(70)
    local row2 = sh - adj(45)
    local row3 = sh - adj(20)

    local col1 = center - adj(545)
    local col2 = center - adj(508)
    local col3 = center - adj(472)
    local col4 = center - adj(418)
    local col5 = center - adj(354)
    local col6 = center - adj(309)
    local col7 = center - adj(273)
    local col8 = center - adj(227)
    local col9 = center - adj(182)

    local scol1 = center + adj(282)
    local scol2 = center + adj(318)
    local scol3 = center + adj(354)
    local scol4 = center + adj(390)
    local scol5 = center + adj(426)
    local scol6 = center + adj(462)

    local kcol1 = center + adj(500)
    local kcol2 = center + adj(525)
    local kcol3 = center + adj(550)

    locations = {
        background = {
            x = center - adj(570),
            y = sh - adj(90)
        },
        class_cooldown_background = {
            x = center + adj(218),
            y = sh - adj(59)
        },
        health_bar = {
            x = center - adj(67),
            y = sh - adj(84),
            width = adj(134),
            height = adj(24)
        },
        health_outline = {
            x = center,
            y = sh - adj(72)
        },
        health = {
            x = center,
            y = sh - adj(33)
        },
        oxygen = {
            x = center + adj(12),
            y = sh - adj(15)
        },
        cycle_weapons = {
            x = center - adj(363),
            y = sh - adj(45)
        },
        cycle_spells = {
            x = center + adj(373),
            y = sh - adj(45)
        },
        level = {
            x = center + adj(210),
            y = sh - adj(47)
        },
        level_with_cooldown = {
            x = center + adj(192),
            y = sh - adj(47)
        },
        spell = {
            x = center + adj(115),
            y = sh - adj(76)
        },
        class_label = {
            x = center + adj(211),
            y = row1
        },
        class_description1 = {
            x = center + adj(210),
            y = sh - adj(32)
        },
        class_description2 = {
            x = center + adj(210),
            y = sh - adj(19)
        },
        class_description_with_cooldown1 = {
            x = center + adj(192),
            y = sh - adj(32)
        },
        class_description_with_cooldown2 = {
            x = center + adj(192),
            y = sh - adj(19)
        },
        class_cooldown = {
            x = center + adj(224),
            y = sh - adj(54),
            width = adj(29),
            height = adj(18)
        },
        class_cooldown_label = {
            x = center + adj(238),
            y = sh - adj(21)
        },
        motion_sensor = {
            x = 0,
            y = sh - adj(150)
        },
        ammo1_only_label = {
            x = center - adj(147),
            y = sh - adj(37)
        },
        ammo1_label = {
            x = center - adj(147),
            y = sh - adj(43)
        },
        ammo2_label = {
            x = center - adj(147),
            y = sh - adj(14)
        },
        fist_label = {
            x = col2,
            y = row1
        },
        fist_level = {
            x = col3,
            y = row1
        },
        pistol_num = {
            x = col1,
            y = row2
        },
        pistol_label = {
            x = col2,
            y = row2
        },
        pistol_level = {
            x = col3,
            y = row2
        },
        fusion_num = {
            x = col1,
            y = row3
        },
        fusion_label = {
            x = col2,
            y = row3
        },
        fusion_level = {
            x = col3,
            y = row3
        },
        shotgun_num = {
            x = col4,
            y = row1
        },
        shotgun_label = {
            x = col5,
            y = row1
        },
        shotgun_level = {
            x = col6,
            y = row1
        },
        ar_num = {
            x = col4,
            y = row2
        },
        ar_label = {
            x = col5,
            y = row2
        },
        ar_level = {
            x = col6,
            y = row2
        },
        smg_num = {
            x = col4,
            y = row3
        },
        smg_label = {
            x = col5,
            y = row3
        },
        smg_level = {
            x = col6,
            y = row3
        },
        flamethrower_num = {
            x = col7,
            y = row1
        },
        flamethrower_label = {
            x = col8,
            y = row1
        },
        flamethrower_level = {
            x = col9,
            y = row1
        },
        rocket_num = {
            x = col7,
            y = row2
        },
        rocket_label = {
            x = col8,
            y = row2
        },
        rocket_level = {
            x = col9,
            y = row2
        },
        alien_weapon_num = {
            x = col7,
            y = row3
        },
        alien_weapon_label = {
            x = col8,
            y = row3
        },
        alien_weapon_level = {
            x = col9,
            y = row3
        },
        energy_can = {
            x = center - adj(57),
            y = sh - adj(30)
        },
        energy_can_label = {
            x = center - adj(50),
            y = sh - adj(13)
        },
        chip = {
            x = center + adj(56),
            y = sh - adj(27)
        },
        spell_yellow_crystal_status = {
            x = scol5,
            y = row3
        },
        spell_yellow_crystal_image = {
            x = scol6,
            y = row3
        },
        spell_ammo_selector_status = {
            x = scol5,
            y = row2
        },
        spell_ammo_selector_image = {
            x = scol6,
            y = row2
        },
        spell_fury_bar_status = {
            x = scol3 - adj(14),
            y = row2 - adj(8),
            width = adj(29),
            height = adj(18)
        },
        spell_fury_status = {
            x = scol3,
            y = row2
        },
        spell_fury_image = {
            x = scol4,
            y = row2
        },
        spell_frozen_orb_status = {
            x = scol3,
            y = row1
        },
        spell_frozen_orb_image = {
            x = scol4,
            y = row1
        },
        spell_lightning_status = {
            x = scol1,
            y = row2
        },
        spell_lightning_image = {
            x = scol2,
            y = row2
        },
        spell_laser_status = {
            x = scol1,
            y = row1
        },
        spell_laser_image = {
            x = scol2,
            y = row1
        },
        spell_reflection_status = {
            x = scol3,
            y = row3
        },
        spell_reflection_image = {
            x = scol4,
            y = row3
        },
        spell_dispersal_dream_status = {
            x = scol1,
            y = row3
        },
        spell_dispersal_dream_image = {
            x = scol2,
            y = row3
        },
        spell_black_hole_status = {
            x = scol5,
            y = row1
        },
        spell_black_hole_image = {
            x = scol6,
            y = row1
        },
        key_red = {
            x = kcol1,
            y = row1
        },
        key_green = {
            x = kcol1,
            y = row2
        },
        key_blue = {
            x = kcol1,
            y = row3
        },
        key_yellow = {
            x = kcol2,
            y = row1
        },
        key_purple = {
            x = kcol2,
            y = row2
        },
        key_teal = {
            x = kcol2,
            y = row3
        },
        key_violet = {
            x = kcol3,
            y = row1
        },
        key_gold = {
            x = kcol3,
            y = row2
        },
        key_white = {
            x = kcol3,
            y = row3
        }
    }
end

function Triggers.init()
    Triggers.resize()

    class_ready_alpha_levels = {}
    for i = 1, 29 do
        table.insert(class_ready_alpha_levels, 1 - (i * 0.015))
    end
    table.insert(class_ready_alpha_levels, .55)
    table.insert(class_ready_alpha_levels, .55)
    for i = 1, 29 do
        table.insert(class_ready_alpha_levels, .5 + (i * 0.015))
    end
end

function load_images()
    imgs = {}
    imgs["background"] = Images.new {path = "resources/background.png"}
    imgs["legend"] = Images.new {path = "resources/legend.png"}
    imgs["talking_background1"] = Images.new {path = "resources/talking_background1.png"}
    imgs["talking_background2"] = Images.new {path = "resources/talking_background2.png"}
    imgs["talking_background3"] = Images.new {path = "resources/talking_background3.png"}
    imgs["talking_background4"] = Images.new {path = "resources/talking_background4.png"}
    imgs["classcooldownbackground"] = Images.new {path = "resources/class_cooldown_background.png"}
    imgs["weppie selected 1"] = Images.new {path = "resources/weppie_selected1.png"}
    imgs["weppie selected 2"] = Images.new {path = "resources/weppie_selected2.png"}
    imgs["weppie selected 3"] = Images.new {path = "resources/weppie_selected3.png"}
    imgs["health outline red"] = Images.new {path = "resources/health_outline_red.png"}
    imgs["health outline yellow"] = Images.new {path = "resources/health_outline_yellow.png"}
    imgs["health outline green"] = Images.new {path = "resources/health_outline_green.png"}
    imgs["spell selected"] = Images.new {path = "resources/spell_selected.png"}
    imgs["motion sensor"] = Images.new {path = "resources/motion_sensor.png"}
    imgs["fist"] = Images.new {path = "resources/fist.png"}
    imgs["pistol"] = Images.new {path = "resources/pistol.png"}
    imgs["fusion"] = Images.new {path = "resources/fusion.png"}
    imgs["shotgun"] = Images.new {path = "resources/shotgun.png"}
    imgs["ar"] = Images.new {path = "resources/ar.png"}
    imgs["smg"] = Images.new {path = "resources/smg.png"}
    imgs["flamethrower"] = Images.new {path = "resources/flamethrower.png"}
    imgs["rl"] = Images.new {path = "resources/rl.png"}
    imgs["aw"] = Images.new {path = "resources/aw.png"}
    imgs["cycleweppies"] = Images.new {path = "resources/cycle_weppies.png"}
    imgs["cyclespells"] = Images.new {path = "resources/cycle_spells.png"}
    imgs["crossedout"] = Images.new {path = "resources/crossed_out.png"}

    imgs[YellowCrystalType] = Images.new {path = "resources/yellow_crystal.png"}
    imgs[AmmoSelectorType] = Images.new {path = "resources/ammo_selector.png"}
    imgs[FuryType] = Images.new {path = "resources/fury.png"}
    imgs[FrozenOrbType] = Images.new {path = "resources/ice_orb.png"}
    imgs[LightningType] = Images.new {path = "resources/lightning.png"}
    imgs[LaserType] = Images.new {path = "resources/laser.png"}
    imgs[ReflectionType] = Images.new {path = "resources/reflect.png"}
    imgs[DispersalDreamType] = Images.new {path = "resources/chain_burst.png"}
    imgs[BlackHoleType] = Images.new {path = "resources/black_hole.png"}
    imgs[BeackpeackType] = Images.new {path = "resources/canvas_bag.png"}

    imgs[YellowCrystalType .. "Small"] = Images.new {path = "resources/yellow_crystal.png"}
    imgs[AmmoSelectorType .. "Small"] = Images.new {path = "resources/ammo_selector.png"}
    imgs[FuryType .. "Small"] = Images.new {path = "resources/fury.png"}
    imgs[FrozenOrbType .. "Small"] = Images.new {path = "resources/ice_orb.png"}
    imgs[LightningType .. "Small"] = Images.new {path = "resources/lightning.png"}
    imgs[LaserType .. "Small"] = Images.new {path = "resources/laser.png"}
    imgs[ReflectionType .. "Small"] = Images.new {path = "resources/reflect.png"}
    imgs[DispersalDreamType .. "Small"] = Images.new {path = "resources/chain_burst.png"}
    imgs[BlackHoleType .. "Small"] = Images.new {path = "resources/black_hole.png"}

    imgs[YellowCrystalType .. "Large"] = Images.new {path = "resources/yellow_crystal.png"}
    imgs[AmmoSelectorType .. "Large"] = Images.new {path = "resources/ammo_selector.png"}
    imgs[FuryType .. "Large"] = Images.new {path = "resources/fury.png"}
    imgs[FrozenOrbType .. "Large"] = Images.new {path = "resources/ice_orb.png"}
    imgs[LightningType .. "Large"] = Images.new {path = "resources/lightning.png"}
    imgs[LaserType .. "Large"] = Images.new {path = "resources/laser.png"}
    imgs[ReflectionType .. "Large"] = Images.new {path = "resources/reflect.png"}
    imgs[DispersalDreamType .. "Large"] = Images.new {path = "resources/chain_burst.png"}
    imgs[BlackHoleType .. "Large"] = Images.new {path = "resources/black_hole.png"}

    imgs["bluekey"] = Images.new {path = "resources/key_blue.png"}
    imgs["goldkey"] = Images.new {path = "resources/key_gold.png"}
    imgs["greenkey"] = Images.new {path = "resources/key_green.png"}
    imgs["purplekey"] = Images.new {path = "resources/key_purple.png"}
    imgs["redkey"] = Images.new {path = "resources/key_red.png"}
    imgs["tealkey"] = Images.new {path = "resources/key_teal.png"}
    imgs["violetkey"] = Images.new {path = "resources/key_violet.png"}
    imgs["whitekey"] = Images.new {path = "resources/key_white.png"}
    imgs["yellowkey"] = Images.new {path = "resources/key_yellow.png"}

    imgs["energycan"] = Images.new {path = "resources/energy_can.png"}
    imgs["chip"] = Images.new {path = "resources/chip.png"}

    imgs["filler"] = Images.new {path = "resources/filler.png"}
    imgs["filler active"] = Images.new {path = "resources/filler_active.png"}
    imgs["filler red"] = Images.new {path = "resources/filler_red.png"}

    imgs["unknown"] = Images.new {path = "resources/unknown.png"}

    imgs["endscreen_success_message"] = Images.new {path = "resources/endscreen_success_message.png"}
    imgs["endscreen_success_score"] = Images.new {path = "resources/endscreen_success_score.png"}
    imgs["endscreen_failure_message"] = Images.new {path = "resources/endscreen_failure_message.png"}
    imgs["endscreen_failure_score"] = Images.new {path = "resources/endscreen_failure_score.png"}

    for idx, name in ipairs(
        {
            "empty energy bar",
            "energy bar",
            "energy bar right",
            "double energy bar",
            "double energy bar right",
            "triple energy bar",
            "triple energy bar right",
            "empty oxygen bar",
            "oxygen bar",
            "oxygen bar right",
            "motion sensor mount",
            "motion sensor virgin mount",
            "motion sensor alien 0",
            "motion sensor alien 1",
            "motion sensor alien 2",
            "motion sensor alien 3",
            "motion sensor alien 4",
            "motion sensor alien 5",
            "motion sensor friend 0",
            "motion sensor friend 1",
            "motion sensor friend 2",
            "motion sensor friend 3",
            "motion sensor friend 4",
            "motion sensor friend 5",
            "motion sensor hostile player 0",
            "motion sensor hostile player 1",
            "motion sensor hostile player 2",
            "motion sensor hostile player 3",
            "motion sensor hostile player 4",
            "motion sensor hostile player 5",
            "network panel"
        }
    ) do
        imgs[name] = Shapes.new {collection = 0, texture_index = idx - 1, type = TextureTypes["interface"]}
    end

    ammo_shapes = {}
    for wt in WeaponTypes() do
        local wep = Player.weapons[wt]

        if wep.primary and wep.primary.bullet_display then
            local disp = wep.primary.bullet_display
            if not ammo_shapes[disp.texture_index] then
                ammo_shapes[disp.texture_index] =
                    Shapes.new {collection = 0, type = TextureTypes["interface"], texture_index = disp.texture_index}
                resize_image(ammo_shapes[disp.texture_index])
            end
            if not ammo_shapes[disp.empty_texture_index] then
                ammo_shapes[disp.empty_texture_index] =
                    Shapes.new {
                    collection = 0,
                    type = TextureTypes["interface"],
                    texture_index = disp.empty_texture_index
                }
                resize_image(ammo_shapes[disp.empty_texture_index])
            end
        end
        if wep.secondary and wep.secondary.bullet_display then
            local disp = wep.secondary.bullet_display
            if disp.texture_index then
                if not ammo_shapes[disp.texture_index] then
                    ammo_shapes[disp.texture_index] =
                        Shapes.new {
                        collection = 0,
                        type = TextureTypes["interface"],
                        texture_index = disp.texture_index
                    }
                    resize_image(ammo_shapes[disp.texture_index])
                end
            end
            if disp.empty_texture_index then
                if not ammo_shapes[disp.empty_texture_index] then
                    ammo_shapes[disp.empty_texture_index] =
                        Shapes.new {
                        collection = 0,
                        type = TextureTypes["interface"],
                        texture_index = disp.empty_texture_index
                    }
                    resize_image(ammo_shapes[disp.empty_texture_index])
                end
            end
        end
    end
end

function resize_images()
    resize_image(imgs["background"])
    resize_image(imgs["legend"])
    resize_image(imgs["talking_background1"])
    resize_image(imgs["talking_background2"])
    resize_image(imgs["talking_background3"])
    resize_image(imgs["talking_background4"])
    resize_image(imgs["classcooldownbackground"])
    resize_image(imgs["weppie selected 1"])
    resize_image(imgs["weppie selected 2"])
    resize_image(imgs["weppie selected 3"])
    resize_image(imgs["health outline red"])
    resize_image(imgs["health outline yellow"])
    resize_image(imgs["health outline green"])
    resize_image(imgs["spell selected"])
    resize_image(imgs["motion sensor"])
    resize_image(imgs["cycleweppies"])
    resize_image(imgs["cyclespells"])
    resize_image(imgs["crossedout"])

    resize_image(imgs[YellowCrystalType])
    resize_image(imgs[AmmoSelectorType])
    resize_image(imgs[FuryType])
    resize_image(imgs[FrozenOrbType])
    resize_image(imgs[LightningType])
    resize_image(imgs[LaserType])
    resize_image(imgs[ReflectionType])
    resize_image(imgs[DispersalDreamType])
    resize_image(imgs[BlackHoleType])
    resize_image(imgs[BeackpeackType])

    resize_image(imgs["bluekey"])
    resize_image(imgs["goldkey"])
    resize_image(imgs["greenkey"])
    resize_image(imgs["purplekey"])
    resize_image(imgs["redkey"])
    resize_image(imgs["tealkey"])
    resize_image(imgs["violetkey"])
    resize_image(imgs["whitekey"])
    resize_image(imgs["yellowkey"])

    resize_image(imgs["energycan"])
    resize_image(imgs["chip"])

    resize_image(imgs["filler"])
    resize_image(imgs["filler active"])
    resize_image(imgs["filler red"])

    resize_image(imgs["unknown"])

    for idx, name in ipairs(
        {
            "empty energy bar",
            "energy bar",
            "energy bar right",
            "double energy bar",
            "double energy bar right",
            "triple energy bar",
            "triple energy bar right",
            "empty oxygen bar",
            "oxygen bar",
            "oxygen bar right",
            "motion sensor mount",
            "motion sensor virgin mount",
            "motion sensor alien 0",
            "motion sensor alien 1",
            "motion sensor alien 2",
            "motion sensor alien 3",
            "motion sensor alien 4",
            "motion sensor alien 5",
            "motion sensor friend 0",
            "motion sensor friend 1",
            "motion sensor friend 2",
            "motion sensor friend 3",
            "motion sensor friend 4",
            "motion sensor friend 5",
            "motion sensor hostile player 0",
            "motion sensor hostile player 1",
            "motion sensor hostile player 2",
            "motion sensor hostile player 3",
            "motion sensor hostile player 4",
            "motion sensor hostile player 5",
            "network panel"
        }
    ) do
        resize_image(imgs[name])
    end

    resize_inventory_image(imgs["fist"])
    resize_inventory_image(imgs["pistol"])
    resize_inventory_image(imgs["fusion"])
    resize_inventory_image(imgs["shotgun"])
    resize_inventory_image(imgs["ar"])
    resize_inventory_image(imgs["smg"])
    resize_inventory_image(imgs["flamethrower"])
    resize_inventory_image(imgs["rl"])
    resize_inventory_image(imgs["aw"])

    resize_inventory_image(imgs[YellowCrystalType .. "Small"])
    resize_inventory_image(imgs[AmmoSelectorType .. "Small"])
    resize_inventory_image(imgs[FuryType .. "Small"])
    resize_inventory_image(imgs[FrozenOrbType .. "Small"])
    resize_inventory_image(imgs[LightningType .. "Small"])
    resize_inventory_image(imgs[LaserType .. "Small"])
    resize_inventory_image(imgs[ReflectionType .. "Small"])
    resize_inventory_image(imgs[DispersalDreamType .. "Small"])
    resize_inventory_image(imgs[BlackHoleType .. "Small"])

    resize_recently_equipped_image(imgs[YellowCrystalType .. "Large"])
    resize_recently_equipped_image(imgs[AmmoSelectorType .. "Large"])
    resize_recently_equipped_image(imgs[FuryType .. "Large"])
    resize_recently_equipped_image(imgs[FrozenOrbType .. "Large"])
    resize_recently_equipped_image(imgs[LightningType .. "Large"])
    resize_recently_equipped_image(imgs[LaserType .. "Large"])
    resize_recently_equipped_image(imgs[ReflectionType .. "Large"])
    resize_recently_equipped_image(imgs[DispersalDreamType .. "Large"])
    resize_recently_equipped_image(imgs[BlackHoleType .. "Large"])

    resize_endscreen_image(imgs["endscreen_success_message"])
    resize_endscreen_image(imgs["endscreen_success_score"])
    resize_endscreen_image(imgs["endscreen_failure_message"])
    resize_endscreen_image(imgs["endscreen_failure_score"])
end

function resize_endscreen_image(img)
    local ratio = img.width / img.height
    local h = Screen.height
    local w = h * ratio
    if w > Screen.width then
        ratio = img.height / img.width
        w = Screen.width
        h = w * ratio
    end
    h = math.floor(h)
    w = math.floor(w)

    img:rescale(w, h)
end

function get_stashed_num(key)
    local val = get_stashed(key)
    return tonumber(val)
end

function get_stashed(key)
    return Level.stash["__ISTORIA__" .. key]
end

function get_stashed_table(key)
    return Game.deserialize(get_stashed(key))
end

function debug_text(text)
    fonts.small:draw_text(text, 50, 50, InterfaceColors["computer text"])
end

function get_laser_display(inventory_data)
    laser_display_count = math.ceil(inventory_data.laser_count / 30)
    if inventory_data.laser_count < 300 then
        laser_display_count = inventory_data.laser_count / 30
        laser_display_count = string.format("%.1f", laser_display_count)
    end
    return laser_display_count
end

function adj(n)
    base = n
    if Screen.hud_size_preference == "double" then
        base = n * 1.16
    elseif Screen.hud_size_preference == "largest" then
        base = n * 1.33
    end

    return base * Screen.width / 1920
end

function game_time_str(ticks, exclude_hours)
    if ticks <= 0 then
        return "0:00:00"
    else
        local ticks = tonumber(ticks)
        local sec = ticks / 30
        local remainder = ticks % 30

        hours = string.format("%01.f", math.floor(sec / 3600))
        mins = string.format("%02.f", math.floor(sec / 60 - (hours * 60)))
        secs = string.format("%02.f", math.floor(sec - hours * 3600 - mins * 60))
        if exclude_hours then
            return mins .. ":" .. secs
        else
            return hours .. ":" .. mins .. ":" .. secs
        end
    end
end

function get_spell_help_x(x, rectwidth, is_unknown)
    if is_unknown then
        return x + ((rectwidth / 2) - (imgs["unknown"].width / 2))
    else
        return x + adj(15)
    end
end

function get_spell_help_text_x(x)
    return x + adj(30) + imgs["unknown"].width
end

function get_spell_help_y(y, rectheight)
    return y + ((rectheight / 2) - (imgs["unknown"].height / 2))
end

function get_mission_bonus(endscreen_good_ending)
    if endscreen_good_ending == "true" then
        return 100, "Success = 100"
    else
        return 0, "Failure = 0"
    end
end

function get_body_count_bonus(body_count_total)
    return math.floor(body_count_total / 100), string.format(
        "%d, +1 per 100 = %d",
        body_count_total,
        math.floor(body_count_total / 100)
    )
end

function get_difficulty_bonus(difficulty_average, difficulty_mode)
    local total_bonus
    local mode_code = 0
    if difficulty_mode == "HardMode" then
        mode_code = 1
    elseif difficulty_mode == "ExtremeMode" then
        mode_code = 2
    end
    if difficulty_average == 1 then
        total_bonus = 0 + mode_code
    elseif difficulty_average == 2 then
        total_bonus = 2 + mode_code
    elseif difficulty_average == 3 then
        total_bonus = 5 + (mode_code * 2)
    elseif difficulty_average == 4 then
        total_bonus = 10 + (mode_code * 3)
    else
        total_bonus = 20 + (mode_code * 5)
    end

    local difficulty_name = "Kindergarten"
    if difficulty_average == 2 then
        difficulty_name = "Easy"
    elseif difficulty_average == 3 then
        difficulty_name = "Normal"
    elseif difficulty_average == 4 then
        difficulty_name = "Major Damage"
    elseif difficulty_average == 5 then
        difficulty_name = "Total Carnage"
    end

    local mode_name = ""
    if mode_code == 1 then
        mode_name = ", Hard"
    elseif mode_code == 2 then
        mode_name = ", Extreme"
    end

    return total_bonus, string.format("%s%s = %d", difficulty_name, mode_name, total_bonus)
end

function get_spell_kills_bonus(spell_kills)
    return math.floor(spell_kills / 50), string.format("%d, +1 per 50 = %d", spell_kills, math.floor(spell_kills / 50))
end

function get_class_activation_bonus(activations)
    local num = 0
    if activations >= 70 then
        num = 25
    end
    return num, string.format("25 if 70+ uses = %d", num)
end

function get_conversation_bonus(num_conversations)
    return num_conversations, string.format("+1 per body = %d", num_conversations)
end

function get_cans_penalty(difficulty_mode, used)
    if difficulty_mode == "HardMode" then
        return math.floor(used / 10) * -1, string.format("-1 per 10 used = %d", math.floor(used / 10) * -1)
    elseif difficulty_mode == "ExtremeMode" then
        return math.floor(used / 15) * -1, string.format("-1 per 15 used = %d", math.floor(used / 15) * -1)
    else
        return math.floor(used / 5) * -1, string.format("-1 per 5 used = %d", math.floor(used / 5) * -1)
    end
end

function get_time_played(ended_time)
    local sec = tonumber(ended_time / 30)

    if sec <= 0 then
        return "00:00:00"
    else
        hours = string.format("%02.f", math.floor(sec / 3600))
        mins = string.format("%02.f", math.floor(sec / 60 - (hours * 60)))
        secs = string.format("%02.f", math.floor(sec - hours * 3600 - mins * 60))
        return hours .. ":" .. mins .. ":" .. secs
    end
end
